/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.key;

import java.io.Serializable;
import java.security.Key;
import java.util.Arrays;
import java.util.Objects;

abstract class RawKey
implements Serializable {
    private static final long serialVersionUID = -5953606815393608941L;
    private final String algorithm;
    private final String format;
    private final byte[] encoded;

    RawKey(Key original) {
        this.algorithm = original.getAlgorithm();
        this.format = original.getFormat();
        byte[] encoded = original.getEncoded();
        this.encoded = encoded == null ? null : (byte[])encoded.clone();
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getFormat() {
        return this.format;
    }

    public byte[] getEncoded() {
        byte[] encoded = this.encoded;
        return encoded == null ? null : (byte[])encoded.clone();
    }

    public final boolean equals(Object obj) {
        return this == obj || obj instanceof Key && this.isEqual((Key)obj);
    }

    public int hashCode() {
        return (this.algorithm != null ? this.algorithm.hashCode() : 1) + (this.format != null ? this.format.hashCode() : 3) + Arrays.hashCode(this.encoded);
    }

    boolean isEqual(Key key) {
        return Objects.equals(key.getAlgorithm(), this.algorithm) && Objects.equals(key.getFormat(), this.format);
    }
}

