/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.net.URI;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.specimpl.ResteasyUriBuilder;
import org.keycloak.models.KeycloakSession;
import org.keycloak.urls.HostnameProvider;

public class KeycloakUriInfo
implements UriInfo {
    private final UriInfo delegate;
    private final String hostname;
    private final int port;
    private URI absolutePath;
    private URI requestURI;
    private URI baseURI;

    public KeycloakUriInfo(KeycloakSession session, UriInfo delegate) {
        this.delegate = delegate;
        HostnameProvider hostnameProvider = session.getProvider(HostnameProvider.class);
        this.hostname = hostnameProvider.getHostname(delegate);
        this.port = hostnameProvider.getPort(delegate);
    }

    public UriInfo getDelegate() {
        return this.delegate;
    }

    public URI getRequestUri() {
        if (this.requestURI == null) {
            this.requestURI = this.delegate.getRequestUriBuilder().host(this.hostname).port(this.port).build(new Object[0]);
        }
        return this.requestURI;
    }

    public UriBuilder getRequestUriBuilder() {
        return UriBuilder.fromUri((URI)this.getRequestUri());
    }

    public URI getAbsolutePath() {
        if (this.absolutePath == null) {
            this.absolutePath = this.delegate.getAbsolutePathBuilder().host(this.hostname).port(this.port).build(new Object[0]);
        }
        return this.absolutePath;
    }

    public UriBuilder getAbsolutePathBuilder() {
        return UriBuilder.fromUri((URI)this.getAbsolutePath());
    }

    public URI getBaseUri() {
        if (this.baseURI == null) {
            this.baseURI = this.delegate.getBaseUriBuilder().host(this.hostname).port(this.port).build(new Object[0]);
        }
        return this.baseURI;
    }

    public UriBuilder getBaseUriBuilder() {
        return UriBuilder.fromUri((URI)this.getBaseUri());
    }

    public URI resolve(URI uri) {
        return this.getBaseUri().resolve(uri);
    }

    public URI relativize(URI uri) {
        URI from = this.getRequestUri();
        URI to = uri;
        if (uri.getScheme() == null && uri.getHost() == null) {
            to = this.getBaseUriBuilder().replaceQuery(null).path(uri.getPath()).replaceQuery(uri.getQuery()).fragment(uri.getFragment()).build(new Object[0]);
        }
        return ResteasyUriBuilder.relativize((URI)from, (URI)to);
    }

    public String getPath() {
        return this.delegate.getPath();
    }

    public String getPath(boolean decode) {
        return this.delegate.getPath(decode);
    }

    public List<PathSegment> getPathSegments() {
        return this.delegate.getPathSegments();
    }

    public List<PathSegment> getPathSegments(boolean decode) {
        return this.delegate.getPathSegments(decode);
    }

    public MultivaluedMap<String, String> getPathParameters() {
        return this.delegate.getPathParameters();
    }

    public MultivaluedMap<String, String> getPathParameters(boolean decode) {
        return this.delegate.getPathParameters(decode);
    }

    public MultivaluedMap<String, String> getQueryParameters() {
        return this.delegate.getQueryParameters();
    }

    public MultivaluedMap<String, String> getQueryParameters(boolean decode) {
        return this.delegate.getQueryParameters(decode);
    }

    public List<String> getMatchedURIs() {
        return this.delegate.getMatchedURIs();
    }

    public List<String> getMatchedURIs(boolean decode) {
        return this.delegate.getMatchedURIs(decode);
    }

    public List<Object> getMatchedResources() {
        return this.delegate.getMatchedResources();
    }
}

