/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.jms.management;

import javax.json.JsonArray;
import javax.json.JsonObject;
import org.apache.activemq.artemis.api.core.JsonUtil;

public class JMSSessionInfo {
    private final String sessionID;
    private final long creationTime;

    public JMSSessionInfo(String sessionID, long creationTime) {
        this.sessionID = sessionID;
        this.creationTime = creationTime;
    }

    public static JMSSessionInfo[] from(String jsonString) {
        JsonArray array = JsonUtil.readJsonArray(jsonString);
        JMSSessionInfo[] infos = new JMSSessionInfo[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            JMSSessionInfo info;
            JsonObject obj = array.getJsonObject(i);
            infos[i] = info = new JMSSessionInfo(obj.getString("sessionID"), obj.getJsonNumber("creationTime").longValue());
        }
        return infos;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public long getCreationTime() {
        return this.creationTime;
    }
}

