/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PropertiesAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartException;
import org.wildfly.extension.elytron.BaseAddHandler;
import org.wildfly.extension.elytron.ClassLoadingAttributeDefinitions;
import org.wildfly.extension.elytron.Configurable;
import org.wildfly.extension.elytron.ElytronDefinition;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.ElytronReloadRequiredWriteAttributeHandler;
import org.wildfly.extension.elytron.SecurityActions;
import org.wildfly.extension.elytron.TrivialCapabilityServiceRemoveHandler;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;

class CustomComponentDefinition<T>
extends SimpleResourceDefinition {
    static final SimpleAttributeDefinition MODULE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(ClassLoadingAttributeDefinitions.MODULE).setRequired(true)).setRestartAllServices()).build();
    static final PropertiesAttributeDefinition CONFIGURATION = ((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)new PropertiesAttributeDefinition.Builder("configuration", true).setAllowExpression(true)).setRestartAllServices()).build();
    private final Class<T> serviceType;
    private final RuntimeCapability<?>[] runtimeCapabilities;
    private final String pathKey;
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{MODULE, ClassLoadingAttributeDefinitions.CLASS_NAME, CONFIGURATION};

    CustomComponentDefinition(Class<T> serviceType, String pathKey, RuntimeCapability ... runtimeCapabilities) {
        super(CustomComponentDefinition.addAddRemoveHandlers(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)pathKey), (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver(pathKey)).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setCapabilities(runtimeCapabilities), serviceType, runtimeCapabilities));
        this.serviceType = serviceType;
        this.runtimeCapabilities = runtimeCapabilities;
        this.pathKey = pathKey;
    }

    private static <T> SimpleResourceDefinition.Parameters addAddRemoveHandlers(SimpleResourceDefinition.Parameters parameters, Class<T> serviceType, RuntimeCapability<?> ... runtimeCapabilities) {
        ComponentAddHandler add = new ComponentAddHandler((Class)serviceType, (RuntimeCapability[])runtimeCapabilities);
        TrivialCapabilityServiceRemoveHandler remove = new TrivialCapabilityServiceRemoveHandler(add, runtimeCapabilities);
        parameters.setAddHandler(add);
        parameters.setRemoveHandler((OperationStepHandler)remove);
        return parameters;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        ElytronReloadRequiredWriteAttributeHandler writeHandler = new ElytronReloadRequiredWriteAttributeHandler(ATTRIBUTES);
        for (AttributeDefinition current : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(current, null, (OperationStepHandler)writeHandler);
        }
    }

    private static class ComponentAddHandler<T>
    extends BaseAddHandler {
        private final RuntimeCapability<?>[] runtimeCapabilities;
        private final Class<T> serviceType;

        private ComponentAddHandler(Class<T> serviceType, RuntimeCapability<?> ... runtimeCapabilities) {
            super(new HashSet<RuntimeCapability>(Arrays.asList(runtimeCapabilities)), ATTRIBUTES);
            this.runtimeCapabilities = runtimeCapabilities;
            this.serviceType = serviceType;
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            ServiceTarget serviceTarget = context.getServiceTarget();
            String address = context.getCurrentAddressValue();
            RuntimeCapability<?> primaryCapability = this.runtimeCapabilities[0];
            ServiceName primaryServiceName = this.toServiceName(primaryCapability, address);
            String module = MODULE.resolveModelAttribute(context, model).asStringOrNull();
            String className = ClassLoadingAttributeDefinitions.CLASS_NAME.resolveModelAttribute(context, model).asString();
            Map configurationMap = CONFIGURATION.unwrap((ExpressionResolver)context, model);
            TrivialService<Object> customComponentService = new TrivialService<Object>(() -> this.createValue(module, className, configurationMap));
            ServiceBuilder serviceBuilder = serviceTarget.addService(primaryServiceName, customComponentService);
            for (int i = 1; i < this.runtimeCapabilities.length; ++i) {
                serviceBuilder.addAliases(new ServiceName[]{this.toServiceName(this.runtimeCapabilities[i], address)});
            }
            ElytronDefinition.commonDependencies(serviceBuilder).setInitialMode(ServiceController.Mode.ACTIVE).install();
        }

        private ServiceName toServiceName(RuntimeCapability<?> runtimeCapability, String addressValue) {
            return runtimeCapability.fromBaseCapability(addressValue).getCapabilityServiceName();
        }

        private T createValue(String module, String className, Map<String, String> configuration) throws StartException {
            try {
                ClassLoader classLoader = SecurityActions.doPrivileged(() -> ClassLoadingAttributeDefinitions.resolveClassLoader(module));
                Class<T> typeClazz = classLoader.loadClass(className).asSubclass(this.serviceType);
                T component = typeClazz.newInstance();
                if (configuration != null && !configuration.isEmpty()) {
                    if (!(component instanceof Configurable)) {
                        throw ElytronSubsystemMessages.ROOT_LOGGER.componentNotConfigurable(component.getClass().getName());
                    }
                    Configurable configurableComponent = (Configurable)component;
                    configurableComponent.initialize(configuration);
                }
                return component;
            }
            catch (PrivilegedActionException e) {
                throw new StartException(e.getCause());
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new StartException((Throwable)e);
            }
        }
    }
}

