/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal;

import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Optional;
import javax.json.bind.JsonbConfig;
import javax.json.bind.JsonbException;
import javax.json.bind.config.PropertyNamingStrategy;
import javax.json.bind.config.PropertyVisibilityStrategy;
import org.eclipse.yasson.internal.model.customization.naming.DefaultNamingStrategies;
import org.eclipse.yasson.internal.model.customization.naming.IdentityStrategy;
import org.eclipse.yasson.internal.model.customization.ordering.AnyOrderStrategy;
import org.eclipse.yasson.internal.model.customization.ordering.LexicographicalOrderStrategy;
import org.eclipse.yasson.internal.model.customization.ordering.PropOrderStrategy;
import org.eclipse.yasson.internal.model.customization.ordering.PropertyOrdering;
import org.eclipse.yasson.internal.model.customization.ordering.ReverseOrderStrategy;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;
import org.eclipse.yasson.internal.serializer.JsonbDateFormatter;

public class JsonbConfigProperties {
    public static final String FAIL_ON_UNKNOWN_PROPERTIES = "jsonb.fail-on-unknown-properties";
    private final JsonbConfig jsonbConfig;
    private final PropertyVisibilityStrategy propertyVisibilityStrategy;
    private final PropertyNamingStrategy propertyNamingStrategy;
    private final PropertyOrdering propertyOrdering;
    private final JsonbDateFormatter dateFormatter;
    private final Locale locale;
    private final String binaryDataStrategy;
    private final boolean nullable;
    private final boolean failOnUnknownProperties;
    private final boolean strictIJson;

    public JsonbConfigProperties(JsonbConfig jsonbConfig) {
        this.jsonbConfig = jsonbConfig;
        this.binaryDataStrategy = this.initBinaryDataStrategy();
        this.propertyNamingStrategy = this.initPropertyNamingStrategy();
        this.propertyVisibilityStrategy = this.initPropertyVisibilityStrategy();
        this.propertyOrdering = new PropertyOrdering(this.initOrderStrategy());
        this.locale = this.initConfigLocale();
        this.dateFormatter = this.initDateFormatter(this.locale);
        this.nullable = this.initConfigNullable();
        this.failOnUnknownProperties = this.initConfigFailOnUnknownProperties();
        this.strictIJson = this.initStrictJson();
    }

    private JsonbDateFormatter initDateFormatter(Locale locale) {
        String dateFormat = this.getGlobalConfigJsonbDateFormat();
        if ("##default".equals(dateFormat) || "##time-in-millis".equals(dateFormat)) {
            return new JsonbDateFormatter(dateFormat, locale.toLanguageTag());
        }
        return new JsonbDateFormatter(DateTimeFormatter.ofPattern(dateFormat, locale), dateFormat, locale.toLanguageTag());
    }

    private String getGlobalConfigJsonbDateFormat() {
        Optional formatProperty = this.jsonbConfig.getProperty("jsonb.date-format");
        return formatProperty.map(f -> {
            if (!(f instanceof String)) {
                throw new JsonbException(Messages.getMessage(MessageKeys.JSONB_CONFIG_PROPERTY_INVALID_TYPE, "jsonb.date-format", String.class.getSimpleName()));
            }
            return (String)f;
        }).orElse("##default");
    }

    private PropOrderStrategy initOrderStrategy() {
        Optional property = this.jsonbConfig.getProperty("jsonb.property-order-strategy");
        if (property.isPresent()) {
            Object strategy = property.get();
            if (!(strategy instanceof String)) {
                throw new JsonbException(Messages.getMessage(MessageKeys.PROPERTY_ORDER, strategy));
            }
            switch ((String)strategy) {
                case "LEXICOGRAPHICAL": {
                    return new LexicographicalOrderStrategy();
                }
                case "REVERSE": {
                    return new ReverseOrderStrategy();
                }
                case "ANY": {
                    return new AnyOrderStrategy();
                }
            }
            throw new JsonbException(Messages.getMessage(MessageKeys.PROPERTY_ORDER, strategy));
        }
        return new LexicographicalOrderStrategy();
    }

    private PropertyNamingStrategy initPropertyNamingStrategy() {
        Optional property = this.jsonbConfig.getProperty("jsonb.property-naming-strategy");
        if (!property.isPresent()) {
            return new IdentityStrategy();
        }
        Object propertyNamingStrategy = property.get();
        if (propertyNamingStrategy instanceof String) {
            String namingStrategyName = (String)propertyNamingStrategy;
            PropertyNamingStrategy foundNamingStrategy = DefaultNamingStrategies.getStrategy(namingStrategyName);
            if (foundNamingStrategy == null) {
                throw new JsonbException("No property naming strategy was found for: " + namingStrategyName);
            }
            return foundNamingStrategy;
        }
        if (!(propertyNamingStrategy instanceof PropertyNamingStrategy)) {
            throw new JsonbException(Messages.getMessage(MessageKeys.PROPERTY_NAMING_STRATEGY_INVALID, new Object[0]));
        }
        return (PropertyNamingStrategy)property.get();
    }

    private PropertyVisibilityStrategy initPropertyVisibilityStrategy() {
        Optional property = this.jsonbConfig.getProperty("jsonb.property-visibility-strategy");
        if (!property.isPresent()) {
            return null;
        }
        Object propertyVisibilityStrategy = property.get();
        if (!(propertyVisibilityStrategy instanceof PropertyVisibilityStrategy)) {
            throw new JsonbException("JsonbConfig.PROPERTY_VISIBILITY_STRATEGY must be instance of " + PropertyVisibilityStrategy.class);
        }
        return (PropertyVisibilityStrategy)propertyVisibilityStrategy;
    }

    private String initBinaryDataStrategy() {
        Optional<Boolean> iJson = this.jsonbConfig.getProperty("jsonb.strict-ijson").map(obj -> (Boolean)obj);
        if (iJson.isPresent() && iJson.get().booleanValue()) {
            return "BASE_64_URL";
        }
        Optional<String> strategy = this.jsonbConfig.getProperty("jsonb.binary-data-strategy").map(obj -> (String)obj);
        return strategy.orElse("BYTE");
    }

    private boolean initConfigNullable() {
        return this.getBooleanConfigProperty("jsonb.null-values", false);
    }

    private boolean initConfigFailOnUnknownProperties() {
        return this.getBooleanConfigProperty(FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public boolean getConfigNullable() {
        return this.nullable;
    }

    public boolean getConfigFailOnUnknownProperties() {
        return this.failOnUnknownProperties;
    }

    private boolean getBooleanConfigProperty(String propertyName, boolean defaultValue) {
        Optional property = this.jsonbConfig.getProperty(propertyName);
        if (property.isPresent()) {
            Object result = property.get();
            if (!(result instanceof Boolean)) {
                throw new JsonbException(Messages.getMessage(MessageKeys.JSONB_CONFIG_PROPERTY_INVALID_TYPE, propertyName, Boolean.class.getSimpleName()));
            }
            return (Boolean)result;
        }
        return defaultValue;
    }

    public String getBinaryDataStrategy() {
        return this.binaryDataStrategy;
    }

    public Locale getLocale(String locale) {
        if (locale.equals("##default")) {
            return this.locale;
        }
        return Locale.forLanguageTag(locale);
    }

    private Locale initConfigLocale() {
        Optional localeProperty = this.jsonbConfig.getProperty("jsonb.locale");
        return localeProperty.map(loc -> {
            if (!(loc instanceof Locale)) {
                throw new JsonbException(Messages.getMessage(MessageKeys.JSONB_CONFIG_PROPERTY_INVALID_TYPE, "jsonb.locale", Locale.class.getSimpleName()));
            }
            return (Locale)loc;
        }).orElseGet(Locale::getDefault);
    }

    private boolean initStrictJson() {
        return this.getBooleanConfigProperty("jsonb.strict-ijson", false);
    }

    public PropertyVisibilityStrategy getPropertyVisibilityStrategy() {
        return this.propertyVisibilityStrategy;
    }

    public PropertyNamingStrategy getPropertyNamingStrategy() {
        return this.propertyNamingStrategy;
    }

    public JsonbDateFormatter getConfigDateFormatter() {
        return this.dateFormatter;
    }

    public PropertyOrdering getPropertyOrdering() {
        return this.propertyOrdering;
    }

    public boolean isStrictIJson() {
        return this.strictIJson;
    }
}

