/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.EnumSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.controller.BinaryCapabilityNameResolver;
import org.jboss.as.clustering.controller.Operations;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceConfiguratorFactory;
import org.jboss.as.clustering.controller.transform.LegacyPropertyAddOperationTransformer;
import org.jboss.as.clustering.controller.transform.LegacyPropertyResourceTransformer;
import org.jboss.as.clustering.controller.transform.SimpleOperationTransformer;
import org.jboss.as.clustering.jgroups.subsystem.AbstractProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.GenericProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsExtension;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsModel;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;

public class ProtocolResourceDefinition
extends AbstractProtocolResourceDefinition {
    static final PathElement WILDCARD_PATH = ProtocolResourceDefinition.pathElement("*");
    static final UnaryOperator<OperationStepHandler> LEGACY_OPERATION_TRANSFORMER = new UnaryOperator<OperationStepHandler>(){

        @Override
        public OperationStepHandler apply(final OperationStepHandler handler) {
            return new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    PathElement legacyPath;
                    PathAddress address = context.getCurrentAddress();
                    PathAddress parentAddress = address.getParent();
                    Resource parent = context.readResourceFromRoot(parentAddress, false);
                    if (parent.hasChild(legacyPath = GenericProtocolResourceDefinition.pathElement(address.getLastElement().getValue()))) {
                        PathAddress legacyAddress = parentAddress.append(new PathElement[]{legacyPath});
                        Operations.setPathAddress((ModelNode)operation, (PathAddress)legacyAddress);
                        String operationName = Operations.getName((ModelNode)operation);
                        context.addStep(operation, context.getRootResourceRegistration().getOperationHandler(legacyAddress, operationName), OperationContext.Stage.MODEL);
                    } else {
                        handler.execute(context, operation);
                    }
                }
            };
        }
    };

    public static PathElement pathElement(String name) {
        return PathElement.pathElement((String)"protocol", (String)name);
    }

    static void addTransformations(ModelVersion version, ResourceTransformationDescriptionBuilder builder) {
        AbstractProtocolResourceDefinition.addTransformations(version, builder);
        if (JGroupsModel.VERSION_4_1_0.requiresTransformation(version)) {
            builder.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new String[]{"add-index"});
        }
        if (JGroupsModel.VERSION_3_0_0.requiresTransformation(version)) {
            org.jboss.as.clustering.controller.transform.OperationTransformer addTransformer = new org.jboss.as.clustering.controller.transform.OperationTransformer(){

                public ModelNode transformOperation(ModelNode operation) {
                    PathAddress address = Operations.getPathAddress((ModelNode)operation);
                    PathAddress stackAddress = address.getParent();
                    ModelNode addProtocolOp = operation.clone();
                    addProtocolOp.get("address").set(stackAddress.toModelNode());
                    addProtocolOp.get("operation").set("add-protocol");
                    addProtocolOp = new LegacyPropertyAddOperationTransformer(op -> Operations.getPathAddress((ModelNode)op).append(new PathElement[]{ProtocolResourceDefinition.pathElement(op.get(AbstractProtocolResourceDefinition.DeprecatedAttribute.TYPE.getName()).asString())})).transformOperation(addProtocolOp);
                    return addProtocolOp;
                }
            };
            builder.addOperationTransformationOverride("add").setCustomOperationTransformer((OperationTransformer)new SimpleOperationTransformer(addTransformer)).inheritResourceAttributeDefinitions();
            org.jboss.as.clustering.controller.transform.OperationTransformer removeTransformer = new org.jboss.as.clustering.controller.transform.OperationTransformer(){

                public ModelNode transformOperation(ModelNode operation) {
                    PathAddress address = Operations.getPathAddress((ModelNode)operation);
                    String protocol = address.getLastElement().getValue();
                    PathAddress stackAddress = address.getParent();
                    ModelNode legacyOperation = Util.createOperation((String)"remove-protocol", (PathAddress)stackAddress);
                    legacyOperation.get(AbstractProtocolResourceDefinition.DeprecatedAttribute.TYPE.getName()).set(protocol);
                    return legacyOperation;
                }
            };
            builder.addOperationTransformationOverride("remove").setCustomOperationTransformer((OperationTransformer)new SimpleOperationTransformer(removeTransformer));
            builder.setCustomResourceTransformer((ResourceTransformer)new LegacyPropertyResourceTransformer());
        }
    }

    ProtocolResourceDefinition(PathElement path, UnaryOperator<ResourceDescriptor> configurator, ResourceServiceConfiguratorFactory serviceConfiguratorFactory, ResourceServiceConfiguratorFactory parentServiceConfiguratorFactory) {
        super(new SimpleResourceDefinition.Parameters(path, path.isWildcard() ? JGroupsExtension.SUBSYSTEM_RESOLVER.createChildResolver(new PathElement[]{path}) : JGroupsExtension.SUBSYSTEM_RESOLVER.createChildResolver(new PathElement[]{path, WILDCARD_PATH})).setOrderedChild(), new ResourceDescriptorConfigurator(configurator), serviceConfiguratorFactory, parentServiceConfiguratorFactory);
    }

    private static class ResourceDescriptorConfigurator
    implements UnaryOperator<ResourceDescriptor> {
        private final UnaryOperator<ResourceDescriptor> configurator;

        ResourceDescriptorConfigurator(UnaryOperator<ResourceDescriptor> configurator) {
            this.configurator = configurator;
        }

        @Override
        public ResourceDescriptor apply(ResourceDescriptor descriptor) {
            return ((ResourceDescriptor)this.configurator.apply(descriptor)).addCapabilities(Capability.class);
        }
    }

    static class LegacyAddOperationTransformation
    implements UnaryOperator<OperationStepHandler> {
        private final Predicate<ModelNode> legacy;

        <E extends Enum<E>> LegacyAddOperationTransformation(Class<E> attributeClass) {
            this.legacy = operation -> {
                for (Attribute attribute : EnumSet.allOf(attributeClass)) {
                    if (!operation.hasDefined(attribute.getName())) continue;
                    return false;
                }
                return true;
            };
        }

        LegacyAddOperationTransformation(String ... legacyProperties) {
            this.legacy = operation -> {
                if (!operation.hasDefined(AbstractProtocolResourceDefinition.Attribute.PROPERTIES.getName())) {
                    return false;
                }
                for (String legacyProperty : legacyProperties) {
                    if (!operation.get(AbstractProtocolResourceDefinition.Attribute.PROPERTIES.getName()).hasDefined(legacyProperty)) continue;
                    return true;
                }
                return false;
            };
        }

        @Override
        public OperationStepHandler apply(OperationStepHandler handler) {
            return (context, operation) -> {
                if (this.legacy.test(operation)) {
                    PathElement path = context.getCurrentAddress().getLastElement();
                    OperationStepHandler genericHandler = context.getResourceRegistration().getParent().getOperationHandler(PathAddress.pathAddress((PathElement[])new PathElement[]{WILDCARD_PATH}), "add");
                    Operations.setPathAddress((ModelNode)operation, (PathAddress)context.getCurrentAddress().getParent().append(new PathElement[]{GenericProtocolResourceDefinition.pathElement(path.getValue())}));
                    context.addStep(operation, genericHandler, OperationContext.Stage.MODEL, true);
                } else {
                    handler.execute(context, operation);
                }
            };
        }
    }

    static enum Capability implements org.jboss.as.clustering.controller.Capability
    {
        PROTOCOL("org.wildfly.clustering.jgroups.protocol");

        private final RuntimeCapability<Void> definition;

        private Capability(String name) {
            this.definition = RuntimeCapability.Builder.of((String)name, (boolean)true).setDynamicNameMapper((Function)BinaryCapabilityNameResolver.PARENT_CHILD).setAllowMultipleRegistrations(true).build();
        }

        public RuntimeCapability<?> getDefinition() {
            return this.definition;
        }
    }
}

