/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.vdx.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.projectodd.vdx.core.Position;
import org.xml.sax.Attributes;

public class DocElement {
    private Position startPosition = new Position(-1, -1);
    private Position endPosition = new Position(-1, -1);
    private final QName name;
    private final Map<String, String> attributes = new HashMap<String, String>();

    public DocElement(QName name, Attributes attributes) {
        this(name, DocElement.attributesToMap(attributes));
    }

    public DocElement(QName name, Map<String, String> attributes) {
        this.name = name;
        if (attributes != null) {
            this.attributes.putAll(attributes);
        }
    }

    public Position startPosition() {
        return this.startPosition;
    }

    public DocElement startPosition(Position position) {
        if (position != null) {
            this.startPosition = position;
        }
        return this;
    }

    public Position endPosition() {
        return this.endPosition;
    }

    public DocElement endPosition(Position endPosition) {
        this.endPosition = endPosition;
        return this;
    }

    public boolean encloses(Position pos) {
        return this.startPosition.compareTo(pos) <= 0 && this.endPosition.compareTo(pos) >= 0;
    }

    public String name() {
        return this.name.getLocalPart();
    }

    public QName qname() {
        return this.name;
    }

    public Map<String, String> attributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public static Map<String, String> attributesToMap(Attributes attributes) {
        HashMap<String, String> attrMap = new HashMap<String, String>();
        for (int i = 0; i < attributes.getLength(); ++i) {
            attrMap.put(attributes.getQName(i), attributes.getValue(i));
        }
        return attrMap;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DocElement)) {
            return false;
        }
        DocElement that = (DocElement)obj;
        return this.qname().equals(that.qname()) && this.attributes.equals(that.attributes) && this.startPosition.equals(that.startPosition) && this.endPosition.equals(that.endPosition);
    }

    public String toString() {
        return "<name=" + this.name + ", attributes=" + this.attributes + ">";
    }
}

