/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.spi.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.IndexedTypeMap;
import org.hibernate.search.spi.impl.DelegatingIndexedTypeMap;

public final class IndexedTypeMaps {
    private IndexedTypeMaps() {
    }

    public static <V> IndexedTypeMap<V> empty() {
        return DelegatingIndexedTypeMap.EMPTY;
    }

    public static <V> IndexedTypeMap<V> hashMap() {
        return new DelegatingIndexedTypeMap(new HashMap(), new HashMap<String, IndexedTypeIdentifier>());
    }

    public static <V> IndexedTypeMap<V> concurrentHashMap() {
        return new DelegatingIndexedTypeMap(new ConcurrentHashMap(), new ConcurrentHashMap<String, IndexedTypeIdentifier>());
    }

    public static <V> IndexedTypeMap<V> singletonMapping(IndexedTypeIdentifier key, V value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        return new DelegatingIndexedTypeMap<V>(Collections.singletonMap(key, value), Collections.singletonMap(key.getName(), key));
    }
}

