/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.legacy;

import java.net.URI;
import java.util.List;
import java.util.Map;
import org.jboss.ejb._private.Logs;
import org.jboss.ejb.client.ClusterNodeSelector;
import org.jboss.ejb.client.DeploymentNodeSelector;
import org.jboss.ejb.client.EJBClientConnection;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.legacy.CommonLegacyConfiguration;
import org.jboss.ejb.client.legacy.JBossEJBProperties;
import org.wildfly.common.function.ExceptionSupplier;
import org.xnio.OptionMap;

public class LegacyPropertiesConfiguration {
    public static void configure(EJBClientContext.Builder builder) {
        JBossEJBProperties properties = JBossEJBProperties.getCurrent();
        if (properties != null) {
            Map<String, JBossEJBProperties.ClusterConfiguration> clusters;
            Logs.MAIN.legacyEJBPropertiesEJBConfigurationInUse();
            List<JBossEJBProperties.ConnectionConfiguration> connectionList = properties.getConnectionList();
            for (JBossEJBProperties.ConnectionConfiguration connectionConfiguration : connectionList) {
                OptionMap connectionOptions;
                URI uri;
                int port;
                String host = connectionConfiguration.getHost();
                if (host == null || (port = connectionConfiguration.getPort()) == -1 || (uri = CommonLegacyConfiguration.getUri(connectionConfiguration, connectionOptions = connectionConfiguration.getConnectionOptions())) == null) continue;
                EJBClientConnection.Builder connectionBuilder = new EJBClientConnection.Builder();
                connectionBuilder.setDestination(uri);
                builder.addClientConnection(connectionBuilder.build());
            }
            ExceptionSupplier<DeploymentNodeSelector, ReflectiveOperationException> deploymentNodeSelectorSupplier = properties.getDeploymentNodeSelectorSupplier();
            if (deploymentNodeSelectorSupplier != null) {
                DeploymentNodeSelector deploymentNodeSelector;
                try {
                    deploymentNodeSelector = (DeploymentNodeSelector)deploymentNodeSelectorSupplier.get();
                }
                catch (ReflectiveOperationException e) {
                    throw Logs.MAIN.cannotInstantiateDeploymentNodeSelector(properties.getDeploymentNodeSelectorClassName(), e);
                }
                builder.setDeploymentNodeSelector(deploymentNodeSelector);
            }
            if ((clusters = properties.getClusterConfigurations()) != null) {
                for (JBossEJBProperties.ClusterConfiguration cluster : clusters.values()) {
                    ExceptionSupplier<ClusterNodeSelector, ReflectiveOperationException> selectorSupplier = cluster.getClusterNodeSelectorSupplier();
                    if (selectorSupplier == null) continue;
                    try {
                        builder.setClusterNodeSelector((ClusterNodeSelector)selectorSupplier.get());
                        break;
                    }
                    catch (ReflectiveOperationException e) {
                        throw Logs.MAIN.cannotInstantiateClustertNodeSelector(cluster.getClusterNodeSelectorClassName(), e);
                    }
                }
            }
            if (properties.getInvocationTimeout() != -1L) {
                builder.setInvocationTimeout(properties.getInvocationTimeout());
            }
        }
    }
}

