/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.https;

import java.security.GeneralSecurityException;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.configuration.jsse.TLSParameterBase;
import org.apache.cxf.configuration.jsse.TLSServerParameters;
import org.apache.cxf.transport.https.AliasedX509ExtendedKeyManager;
import org.apache.cxf.transport.https.AllowAllHostnameVerifier;
import org.apache.cxf.transport.https.httpclient.DefaultHostnameVerifier;
import org.apache.cxf.transport.https.httpclient.PublicSuffixMatcherLoader;

public final class SSLUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(SSLUtils.class);

    private SSLUtils() {
    }

    public static HostnameVerifier getHostnameVerifier(TLSClientParameters tlsClientParameters) {
        HostnameVerifier verifier = tlsClientParameters.getHostnameVerifier() != null ? tlsClientParameters.getHostnameVerifier() : (tlsClientParameters.isUseHttpsURLConnectionDefaultHostnameVerifier() ? HttpsURLConnection.getDefaultHostnameVerifier() : (tlsClientParameters.isDisableCNCheck() ? new AllowAllHostnameVerifier() : new DefaultHostnameVerifier(PublicSuffixMatcherLoader.getDefault())));
        return verifier;
    }

    public static SSLContext getSSLContext(TLSParameterBase parameters) throws GeneralSecurityException {
        KeyManager[] keyManagers;
        SSLContext ctx;
        String provider = parameters.getJsseProvider();
        String protocol = parameters.getSecureSocketProtocol() != null ? parameters.getSecureSocketProtocol() : "TLS";
        SSLContext sSLContext = ctx = provider == null ? SSLContext.getInstance(protocol) : SSLContext.getInstance(protocol, provider);
        if (parameters instanceof TLSClientParameters) {
            ctx.getClientSessionContext().setSessionTimeout(((TLSClientParameters)parameters).getSslCacheTimeout());
        }
        if ((keyManagers = parameters.getKeyManagers()) == null && parameters instanceof TLSClientParameters) {
            keyManagers = org.apache.cxf.configuration.jsse.SSLUtils.getDefaultKeyStoreManagers((Logger)LOG);
        }
        SSLUtils.configureKeyManagersWithCertAlias(parameters, keyManagers);
        TrustManager[] trustManagers = parameters.getTrustManagers();
        if (trustManagers == null && parameters instanceof TLSClientParameters) {
            trustManagers = org.apache.cxf.configuration.jsse.SSLUtils.getDefaultTrustStoreManagers((Logger)LOG);
        }
        ctx.init(keyManagers, trustManagers, parameters.getSecureRandom());
        return ctx;
    }

    public static void configureKeyManagersWithCertAlias(TLSParameterBase tlsParameters, KeyManager[] keyManagers) throws GeneralSecurityException {
        if (tlsParameters.getCertAlias() != null && keyManagers != null) {
            for (int idx = 0; idx < keyManagers.length; ++idx) {
                if (!(keyManagers[idx] instanceof X509KeyManager) || keyManagers[idx] instanceof AliasedX509ExtendedKeyManager) continue;
                try {
                    keyManagers[idx] = new AliasedX509ExtendedKeyManager(tlsParameters.getCertAlias(), (X509KeyManager)keyManagers[idx]);
                    continue;
                }
                catch (Exception e) {
                    throw new GeneralSecurityException(e);
                }
            }
        }
    }

    public static SSLEngine createServerSSLEngine(TLSServerParameters parameters) throws Exception {
        SSLContext sslContext = SSLUtils.getSSLContext((TLSParameterBase)parameters);
        SSLEngine serverEngine = sslContext.createSSLEngine();
        serverEngine.setUseClientMode(false);
        serverEngine.setNeedClientAuth(parameters.getClientAuthentication().isRequired());
        return serverEngine;
    }

    public static SSLEngine createClientSSLEngine(TLSClientParameters parameters) throws Exception {
        SSLContext sslContext = SSLUtils.getSSLContext((TLSParameterBase)parameters);
        SSLEngine clientEngine = sslContext.createSSLEngine();
        clientEngine.setUseClientMode(true);
        return clientEngine;
    }
}

