/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.expiration.impl.ClusterExpirationManager;
import org.infinispan.expiration.impl.ExpirationManagerImpl;
import org.infinispan.expiration.impl.InternalExpirationManager;
import org.infinispan.expiration.impl.TxClusterExpirationManager;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;

@DefaultFactoryFor(classes={InternalExpirationManager.class})
public class ExpirationManagerFactory
extends AbstractNamedCacheComponentFactory
implements AutoInstantiableFactory {
    @Override
    public <T> T construct(Class<T> componentType) {
        CacheMode cacheMode = this.configuration.clustering().cacheMode();
        if (cacheMode.needsStateTransfer()) {
            if (this.configuration.transaction().transactionMode().isTransactional()) {
                return componentType.cast(new TxClusterExpirationManager());
            }
            return componentType.cast(new ClusterExpirationManager());
        }
        return componentType.cast(new ExpirationManagerImpl());
    }
}

