/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms;

import java.util.Arrays;
import java.util.Collection;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.wildfly.extension.messaging.activemq.MessagingExtension;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryAdd;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryAttribute;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryAttributes;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryRemove;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryUpdateJndiHandler;

public class ConnectionFactoryDefinition
extends PersistentResourceDefinition {
    public static final AttributeDefinition[] ATTRIBUTES = ConnectionFactoryDefinition.concat(ConnectionFactoryAttributes.Regular.ATTRIBUTES, ConnectionFactoryAttribute.getDefinitions(ConnectionFactoryAttributes.Common.ATTRIBUTES));
    private final boolean registerRuntimeOnly;

    static final AttributeDefinition[] concat(AttributeDefinition[] common, AttributeDefinition ... specific) {
        int size = common.length + specific.length;
        AttributeDefinition[] result = new AttributeDefinition[size];
        System.arraycopy(common, 0, result, 0, common.length);
        System.arraycopy(specific, 0, result, common.length, specific.length);
        return result;
    }

    public ConnectionFactoryDefinition(boolean registerRuntimeOnly) {
        super(MessagingExtension.CONNECTION_FACTORY_PATH, MessagingExtension.getResourceDescriptionResolver("connection-factory"), (OperationStepHandler)ConnectionFactoryAdd.INSTANCE, (OperationStepHandler)ConnectionFactoryRemove.INSTANCE);
        this.registerRuntimeOnly = registerRuntimeOnly;
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(ATTRIBUTES);
    }

    public void registerOperations(ManagementResourceRegistration registry) {
        super.registerOperations(registry);
        if (this.registerRuntimeOnly) {
            ConnectionFactoryUpdateJndiHandler.registerOperations(registry, this.getResourceDescriptionResolver());
        }
    }
}

