/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import javax.jms.ConnectionFactory;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.jboss.as.network.ManagedBinding;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.network.SocketBinding;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.extension.messaging.activemq.DiscoveryGroupAdd;
import org.wildfly.extension.messaging.activemq.TransportConfigOperationHandlers;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;

public class ExternalConnectionFactoryService
implements Service<ConnectionFactory> {
    private final boolean ha;
    private final DiscoveryGroupConfiguration groupConfiguration;
    private final TransportConfiguration[] connectors;
    private final JMSFactoryType type;
    private final Map<String, Supplier<SocketBinding>> socketBindings;
    private final Map<String, Supplier<OutboundSocketBinding>> outboundSocketBindings;
    private final Map<String, Supplier<SocketBinding>> groupBindings;
    private final Map<String, String> clusterNames;
    private final Map<String, Supplier<CommandDispatcherFactory>> commandDispatcherFactories;
    private ActiveMQConnectionFactory factory;

    ExternalConnectionFactoryService(DiscoveryGroupConfiguration groupConfiguration, Map<String, Supplier<CommandDispatcherFactory>> commandDispatcherFactories, Map<String, Supplier<SocketBinding>> groupBindings, Map<String, String> clusterNames, JMSFactoryType type, boolean ha) {
        this(ha, type, groupConfiguration, Collections.emptyMap(), Collections.emptyMap(), commandDispatcherFactories, groupBindings, clusterNames, null);
    }

    ExternalConnectionFactoryService(TransportConfiguration[] connectors, Map<String, Supplier<SocketBinding>> socketBindings, Map<String, Supplier<OutboundSocketBinding>> outboundSocketBindings, JMSFactoryType type, boolean ha) {
        this(ha, type, null, socketBindings, outboundSocketBindings, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), connectors);
    }

    private ExternalConnectionFactoryService(boolean ha, JMSFactoryType type, DiscoveryGroupConfiguration groupConfiguration, Map<String, Supplier<SocketBinding>> socketBindings, Map<String, Supplier<OutboundSocketBinding>> outboundSocketBindings, Map<String, Supplier<CommandDispatcherFactory>> commandDispatcherFactories, Map<String, Supplier<SocketBinding>> groupBindings, Map<String, String> clusterNames, TransportConfiguration[] connectors) {
        assert (connectors != null && connectors.length > 0 || groupConfiguration != null);
        this.ha = ha;
        this.type = type;
        this.groupConfiguration = groupConfiguration;
        this.connectors = connectors;
        this.socketBindings = socketBindings;
        this.outboundSocketBindings = outboundSocketBindings;
        this.clusterNames = clusterNames;
        this.commandDispatcherFactories = commandDispatcherFactories;
        this.groupBindings = groupBindings;
    }

    public void start(StartContext context) throws StartException {
        try {
            if (this.connectors != null && this.connectors.length > 0) {
                TransportConfigOperationHandlers.processConnectorBindings(Arrays.asList(this.connectors), this.socketBindings, this.outboundSocketBindings);
                this.factory = this.ha ? ActiveMQJMSClient.createConnectionFactoryWithHA((JMSFactoryType)this.type, (TransportConfiguration[])this.connectors) : ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)this.type, (TransportConfiguration[])this.connectors);
            } else {
                DiscoveryGroupConfiguration config;
                String name = this.groupConfiguration.getName();
                String key = "discovery" + name;
                if (this.commandDispatcherFactories.containsKey(key)) {
                    CommandDispatcherFactory commandDispatcherFactory = this.commandDispatcherFactories.get(key).get();
                    String clusterName = this.clusterNames.get(key);
                    config = DiscoveryGroupAdd.createDiscoveryGroupConfiguration(name, this.groupConfiguration, commandDispatcherFactory, clusterName);
                } else {
                    SocketBinding binding = this.groupBindings.get(key).get();
                    if (binding == null) {
                        throw MessagingLogger.ROOT_LOGGER.failedToFindDiscoverySocketBinding(name);
                    }
                    config = DiscoveryGroupAdd.createDiscoveryGroupConfiguration(name, this.groupConfiguration, binding);
                    binding.getSocketBindings().getNamedRegistry().registerBinding(ManagedBinding.Factory.createSimpleManagedBinding((SocketBinding)binding));
                }
                this.factory = this.ha ? ActiveMQJMSClient.createConnectionFactoryWithHA((DiscoveryGroupConfiguration)config, (JMSFactoryType)this.type) : ActiveMQJMSClient.createConnectionFactoryWithoutHA((DiscoveryGroupConfiguration)config, (JMSFactoryType)this.type);
            }
        }
        catch (Throwable e) {
            throw MessagingLogger.ROOT_LOGGER.failedToCreate(e, "connection-factory");
        }
    }

    public void stop(StopContext context) {
        try {
            this.factory.close();
        }
        catch (Throwable e) {
            MessagingLogger.ROOT_LOGGER.failedToDestroy("connection-factory", "");
        }
    }

    public ConnectionFactory getValue() throws IllegalStateException, IllegalArgumentException {
        return this.factory;
    }
}

