/*
 * Decompiled with CFR 0.152.
 */
package org.kie.internal.logger;

import org.kie.api.event.KieRuntimeEventManager;
import org.kie.api.logger.KieLoggers;
import org.kie.api.logger.KieRuntimeLogger;

public class KnowledgeRuntimeLoggerFactory {
    private static KieLoggers knowledgeRuntimeLoggerFactoryService;

    public static KieRuntimeLogger newFileLogger(KieRuntimeEventManager session, String fileName) {
        return KnowledgeRuntimeLoggerFactory.getKnowledgeRuntimeLoggerProvider().newFileLogger(session, fileName);
    }

    public static KieRuntimeLogger newThreadedFileLogger(KieRuntimeEventManager session, String fileName, int interval) {
        return KnowledgeRuntimeLoggerFactory.getKnowledgeRuntimeLoggerProvider().newThreadedFileLogger(session, fileName, interval);
    }

    public static KieRuntimeLogger newConsoleLogger(KieRuntimeEventManager session) {
        return KnowledgeRuntimeLoggerFactory.getKnowledgeRuntimeLoggerProvider().newConsoleLogger(session);
    }

    private static synchronized void setKnowledgeRuntimeLoggerProvider(KieLoggers provider) {
        knowledgeRuntimeLoggerFactoryService = provider;
    }

    private static synchronized KieLoggers getKnowledgeRuntimeLoggerProvider() {
        if (knowledgeRuntimeLoggerFactoryService == null) {
            KnowledgeRuntimeLoggerFactory.loadProvider();
        }
        return knowledgeRuntimeLoggerFactoryService;
    }

    private static void loadProvider() {
        try {
            Class<?> cls = Class.forName("org.drools.core.audit.KnowledgeRuntimeLoggerProviderImpl");
            KnowledgeRuntimeLoggerFactory.setKnowledgeRuntimeLoggerProvider((KieLoggers)cls.newInstance());
        }
        catch (Exception e) {
            throw new RuntimeException("Provider org.drools.core.audit.KnowledgeRuntimeLoggerProviderImpl could not be set.", e);
        }
    }
}

