/*
 * Decompiled with CFR 0.152.
 */
package org.kie.scanner;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.appformer.maven.integration.ArtifactResolver;
import org.appformer.maven.integration.DependencyDescriptor;
import org.appformer.maven.support.AFReleaseId;
import org.appformer.maven.support.DependencyFilter;
import org.appformer.maven.support.PomModel;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.InternalKieModuleProvider;
import org.drools.compiler.kie.builder.impl.InternalKieScanner;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.compiler.kie.builder.impl.MemoryKieModule;
import org.drools.compiler.kie.builder.impl.ResultsImpl;
import org.drools.compiler.kproject.ReleaseIdImpl;
import org.drools.compiler.kproject.models.KieModuleModelImpl;
import org.drools.core.impl.InternalKieContainer;
import org.eclipse.aether.artifact.Artifact;
import org.kie.api.KieServices;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.KieScanner;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.Results;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.event.kiescanner.KieScannerEventListener;
import org.kie.api.runtime.KieContainer;
import org.kie.scanner.KieScannersRegistry;
import org.kie.scanner.event.KieScannerEventSupport;
import org.kie.scanner.management.KieScannerMBean;
import org.kie.scanner.management.KieScannerMBeanImpl;
import org.kie.scanner.management.MBeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieRepositoryScannerImpl
implements InternalKieScanner {
    private Timer timer;
    private static final Logger log = LoggerFactory.getLogger(KieScanner.class);
    private InternalKieContainer kieContainer;
    private DependencyDescriptor kieProjectDescr;
    private Map<ReleaseId, DependencyDescriptor> usedDependencies;
    private ArtifactResolver artifactResolver;
    private volatile KieScanner.Status status = KieScanner.Status.STARTING;
    private KieScannerMBean mbean;
    private long pollingInterval;
    private KieScannerEventSupport listeners = new KieScannerEventSupport();

    public void addListener(KieScannerEventListener listener) {
        this.listeners.addEventListener((EventListener)listener);
    }

    public void removeListener(KieScannerEventListener listener) {
        this.listeners.removeEventListener((EventListener)listener);
    }

    public Collection<KieScannerEventListener> getListeners() {
        return this.listeners.getEventListeners();
    }

    private void changeStatus(KieScanner.Status status) {
        this.status = status;
        this.listeners.fireKieScannerStatusChangeEventImpl(status);
    }

    public synchronized void setKieContainer(KieContainer kieContainer) {
        if (this.kieContainer != null) {
            throw new RuntimeException("Cannot change KieContainer on an already initialized KieScanner");
        }
        this.kieContainer = (InternalKieContainer)kieContainer;
        if (this.kieContainer.getContainerReleaseId() == null) {
            throw new RuntimeException("The KieContainer's ReleaseId cannot be null. Are you using a KieClasspathContainer?");
        }
        this.artifactResolver = KieRepositoryScannerImpl.getResolverFor(this.kieContainer, true);
        this.kieProjectDescr = new DependencyDescriptor((AFReleaseId)this.kieContainer.getReleaseId(), this.kieContainer.getCreationTimestamp());
        this.usedDependencies = this.indexArtifacts();
        KieScannersRegistry.register(this);
        this.changeStatus(KieScanner.Status.STOPPED);
        if (MBeanUtils.isMBeanEnabled()) {
            this.mbean = new KieScannerMBeanImpl(this);
        }
    }

    private ArtifactResolver getArtifactResolver() {
        if (this.artifactResolver == null) {
            this.artifactResolver = new ArtifactResolver();
        }
        return this.artifactResolver;
    }

    public synchronized KieModule loadArtifact(ReleaseId releaseId) {
        return this.loadArtifact(releaseId, this.getArtifactResolver());
    }

    public synchronized KieModule loadArtifact(ReleaseId releaseId, InputStream pomXml) {
        ArtifactResolver resolver = pomXml != null ? ArtifactResolver.getResolverFor((InputStream)pomXml) : this.getArtifactResolver();
        return this.loadArtifact(releaseId, resolver);
    }

    public synchronized KieModule loadArtifact(ReleaseId releaseId, PomModel pomModel) {
        ArtifactResolver resolver = pomModel != null ? ArtifactResolver.getResolverFor((PomModel)pomModel) : this.getArtifactResolver();
        return this.loadArtifact(releaseId, resolver);
    }

    private KieModule loadArtifact(ReleaseId releaseId, ArtifactResolver resolver) {
        Artifact artifact = resolver.resolveArtifact((AFReleaseId)releaseId);
        return artifact != null ? this.buildArtifact(artifact, resolver) : this.loadPomArtifact(releaseId);
    }

    public synchronized String getArtifactVersion(ReleaseId releaseId) {
        if (!releaseId.isSnapshot()) {
            return releaseId.getVersion();
        }
        Artifact artifact = this.getArtifactResolver().resolveArtifact((AFReleaseId)releaseId);
        return artifact != null ? artifact.getVersion() : null;
    }

    public synchronized ReleaseId getScannerReleaseId() {
        return this.kieContainer.getContainerReleaseId();
    }

    public synchronized ReleaseId getCurrentReleaseId() {
        return this.kieContainer.getReleaseId();
    }

    public synchronized KieScanner.Status getStatus() {
        return this.status;
    }

    private KieModule loadPomArtifact(ReleaseId releaseId) {
        ArtifactResolver resolver = ArtifactResolver.getResolverFor((AFReleaseId)releaseId, (boolean)false);
        if (resolver == null) {
            return null;
        }
        MemoryKieModule kieModule = new MemoryKieModule(releaseId);
        this.addDependencies((InternalKieModule)kieModule, resolver, resolver.getPomDirectDependencies(DependencyFilter.COMPILE_FILTER));
        kieModule.build();
        return kieModule;
    }

    private InternalKieModule buildArtifact(Artifact artifact, ArtifactResolver resolver) {
        DependencyDescriptor dependencyDescriptor = new DependencyDescriptor(artifact);
        ReleaseIdImpl releaseId = ReleaseIdImpl.adapt((AFReleaseId)dependencyDescriptor.getReleaseId());
        InternalKieModule kieModule = KieRepositoryScannerImpl.createKieModule((AFReleaseId)releaseId, artifact.getFile());
        if (kieModule != null) {
            this.addDependencies(kieModule, resolver, resolver.getArtifactDependecies(dependencyDescriptor.toString()));
            kieModule.build();
        }
        return kieModule;
    }

    private void addDependencies(InternalKieModule kieModule, ArtifactResolver resolver, List<DependencyDescriptor> dependencies) {
        for (DependencyDescriptor dep : dependencies) {
            ReleaseIdImpl depReleaseId;
            InternalKieModule zipKieModule;
            InternalKieModule dependency = (InternalKieModule)KieServices.Factory.get().getRepository().getKieModule((ReleaseId)ReleaseIdImpl.adapt((AFReleaseId)dep.getReleaseId()));
            if (dependency != null) {
                kieModule.addKieDependency(dependency);
                continue;
            }
            Artifact depArtifact = resolver.resolveArtifact(dep.getReleaseId());
            if (depArtifact == null || !this.isKJar(depArtifact.getFile()) || (zipKieModule = KieRepositoryScannerImpl.createKieModule((AFReleaseId)(depReleaseId = ReleaseIdImpl.adapt((AFReleaseId)new DependencyDescriptor(depArtifact).getReleaseId())), depArtifact.getFile())) == null) continue;
            kieModule.addKieDependency(zipKieModule);
        }
    }

    private static InternalKieModule createKieModule(AFReleaseId releaseId, File jar) {
        KieModuleModel kieModuleModel = KieRepositoryScannerImpl.getKieModuleModelFromJar(jar);
        return kieModuleModel != null ? InternalKieModuleProvider.get((ReleaseId)ReleaseIdImpl.adapt((AFReleaseId)releaseId), (KieModuleModel)kieModuleModel, (File)jar) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KieModuleModel getKieModuleModelFromJar(File jar) {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(jar);
            ZipEntry zipEntry = zipFile.getEntry("META-INF/kmodule.xml");
            KieModuleModel kieModuleModel = KieModuleModelImpl.fromXML((InputStream)zipFile.getInputStream(zipEntry));
            KieBuilderImpl.setDefaultsforEmptyKieModule((KieModuleModel)kieModuleModel);
            KieModuleModel kieModuleModel2 = kieModuleModel;
            return kieModuleModel2;
        }
        catch (Exception exception) {
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public synchronized void start(long pollingInterval) {
        if (this.getStatus() == KieScanner.Status.SHUTDOWN) {
            throw new IllegalStateException("The scanner was shut down and can no longer be started.");
        }
        if (pollingInterval <= 0L) {
            throw new IllegalArgumentException("pollingInterval must be positive");
        }
        if (this.timer != null) {
            throw new IllegalStateException("The scanner is already running");
        }
        this.startScanTask(pollingInterval);
    }

    public synchronized void stop() {
        if (this.getStatus() == KieScanner.Status.SHUTDOWN) {
            throw new IllegalStateException("The scanner was already shut down.");
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        this.pollingInterval = 0L;
        this.changeStatus(KieScanner.Status.STOPPED);
    }

    public synchronized long getPollingInterval() {
        return this.pollingInterval;
    }

    public void shutdown() {
        if (this.getStatus() != KieScanner.Status.SHUTDOWN) {
            this.stop();
            this.changeStatus(KieScanner.Status.SHUTDOWN);
        }
    }

    private void startScanTask(long pollingInterval) {
        this.changeStatus(KieScanner.Status.RUNNING);
        this.pollingInterval = pollingInterval;
        this.timer = new Timer(true);
        this.timer.schedule((TimerTask)new ScanTask(), pollingInterval, pollingInterval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void scanNow() {
        if (this.getStatus() == KieScanner.Status.SHUTDOWN) {
            throw new IllegalStateException("The scanner was already shut down and can no longer be used.");
        }
        KieScanner.Status originalStatus = this.status;
        try {
            this.changeStatus(KieScanner.Status.SCANNING);
            Map<DependencyDescriptor, Artifact> updatedArtifacts = this.scanForUpdates();
            if (updatedArtifacts.isEmpty()) {
                this.changeStatus(originalStatus);
                return;
            }
            this.changeStatus(KieScanner.Status.UPDATING);
            boolean allUpdatesSucceeded = true;
            Map.Entry<DependencyDescriptor, Artifact> containerEntry = null;
            for (Map.Entry<DependencyDescriptor, Artifact> entry : updatedArtifacts.entrySet()) {
                if (entry.getKey().isSameArtifact((AFReleaseId)this.kieContainer.getContainerReleaseId())) {
                    containerEntry = entry;
                    continue;
                }
                allUpdatesSucceeded = this.updateKieModule(entry.getKey(), entry.getValue()) && allUpdatesSucceeded;
            }
            if (containerEntry != null) {
                boolean bl = allUpdatesSucceeded = this.updateKieModule((DependencyDescriptor)containerEntry.getKey(), (Artifact)containerEntry.getValue()) && allUpdatesSucceeded;
            }
            if (allUpdatesSucceeded) {
                log.info("The following artifacts have been updated: " + updatedArtifacts);
            } else {
                log.error("Some errors occured while updating the following artifacts: " + updatedArtifacts);
            }
        }
        finally {
            this.changeStatus(originalStatus);
        }
    }

    private boolean updateKieModule(DependencyDescriptor oldDependency, Artifact artifact) {
        AFReleaseId newReleaseId = new DependencyDescriptor(artifact).getReleaseId();
        InternalKieModule kieModule = KieRepositoryScannerImpl.createKieModule(newReleaseId, artifact.getFile());
        if (kieModule != null) {
            this.addDependencies(kieModule, this.artifactResolver, this.artifactResolver.getArtifactDependecies(newReleaseId.toString()));
            ResultsImpl messages = kieModule.build();
            if (messages.filterMessages(new Message.Level[]{Message.Level.ERROR}).isEmpty()) {
                Results updateMessages = this.kieContainer.updateDependencyToVersion((ReleaseId)ReleaseIdImpl.adapt((AFReleaseId)oldDependency.getArtifactReleaseId()), (ReleaseId)ReleaseIdImpl.adapt((AFReleaseId)newReleaseId));
                oldDependency.setArtifactVersion(artifact.getVersion());
                messages.getMessages().addAll(updateMessages.getMessages());
            }
            this.listeners.fireKieScannerUpdateResultsEventImpl((Results)messages);
            return !messages.hasMessages(new Message.Level[]{Message.Level.ERROR});
        }
        return false;
    }

    private Map<DependencyDescriptor, Artifact> scanForUpdates() {
        DependencyDescriptor resolvedDep;
        this.artifactResolver = KieRepositoryScannerImpl.getResolverFor(this.kieContainer, true);
        if (!this.kieProjectDescr.getReleaseId().equals(this.kieContainer.getReleaseId())) {
            this.kieProjectDescr = new DependencyDescriptor((AFReleaseId)this.kieContainer.getReleaseId(), this.kieContainer.getCreationTimestamp());
        }
        HashMap<DependencyDescriptor, Artifact> newArtifacts = new HashMap<DependencyDescriptor, Artifact>();
        Artifact newArtifact = this.artifactResolver.resolveArtifact((AFReleaseId)this.kieContainer.getConfiguredReleaseId());
        if (newArtifact != null && (resolvedDep = new DependencyDescriptor(newArtifact)).isNewerThan(this.kieProjectDescr)) {
            newArtifacts.put(this.kieProjectDescr, newArtifact);
            this.kieProjectDescr = new DependencyDescriptor(newArtifact);
        }
        for (DependencyDescriptor dep : this.artifactResolver.getAllDependecies()) {
            DependencyDescriptor newDep;
            ReleaseIdImpl artifactId = ReleaseIdImpl.adapt((AFReleaseId)dep.getReleaseIdWithoutVersion());
            DependencyDescriptor oldDep = this.usedDependencies.get(artifactId);
            if (oldDep == null || (newArtifact = this.artifactResolver.resolveArtifact(dep.getReleaseId())) == null || !(newDep = new DependencyDescriptor(newArtifact)).isNewerThan(oldDep)) continue;
            newArtifacts.put(oldDep, newArtifact);
            this.usedDependencies.put((ReleaseId)artifactId, newDep);
        }
        return newArtifacts;
    }

    private Map<ReleaseId, DependencyDescriptor> indexArtifacts() {
        HashMap<ReleaseId, DependencyDescriptor> depsMap = new HashMap<ReleaseId, DependencyDescriptor>();
        for (DependencyDescriptor dep : this.artifactResolver.getAllDependecies()) {
            if (!("test".equals(dep.getScope()) || "provided".equals(dep.getScope()) || "system".equals(dep.getScope()))) {
                Artifact artifact = this.artifactResolver.resolveArtifact(dep.getReleaseId());
                if (artifact == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug(artifact + " resolved to  " + artifact.getFile());
                }
                if (!this.isKJar(artifact.getFile())) continue;
                depsMap.put((ReleaseId)ReleaseIdImpl.adapt((AFReleaseId)dep.getReleaseIdWithoutVersion()), new DependencyDescriptor(artifact));
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("{} does not need to be resolved because in scope {}", (Object)dep, (Object)dep.getScope());
        }
        return depsMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isKJar(File jar) {
        try (ZipFile zipFile = new ZipFile(jar);){
            ZipEntry zipEntry = zipFile.getEntry("META-INF/kmodule.xml");
            boolean bl = zipEntry != null;
            return bl;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to open Zip file '" + jar.getAbsolutePath() + "'!", e);
        }
    }

    public synchronized KieScannerMBean getMBean() {
        return this.mbean;
    }

    public static ArtifactResolver getResolverFor(InternalKieContainer kieContainer, boolean allowDefaultPom) {
        return ArtifactResolver.getResolverFor((InputStream)kieContainer.getPomAsStream(), (AFReleaseId)kieContainer.getReleaseId(), (boolean)allowDefaultPom);
    }

    private class ScanTask
    extends TimerTask {
        private ScanTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            KieRepositoryScannerImpl kieRepositoryScannerImpl = KieRepositoryScannerImpl.this;
            synchronized (kieRepositoryScannerImpl) {
                if (KieRepositoryScannerImpl.this.status == KieScanner.Status.STOPPED) {
                    return;
                }
                KieRepositoryScannerImpl.this.scanNow();
                KieRepositoryScannerImpl.this.changeStatus(KieScanner.Status.RUNNING);
            }
        }
    }
}

