/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.federation.model.sp;

import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.RestartParentWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.picketlink.common.model.ModelElement;
import org.wildfly.extension.picketlink.federation.model.AbstractFederationResourceDefinition;
import org.wildfly.extension.picketlink.federation.model.handlers.HandlerResourceDefinition;
import org.wildfly.extension.picketlink.federation.model.sp.ServiceProviderAddHandler;
import org.wildfly.extension.picketlink.federation.model.sp.ServiceProviderMetricsOperationHandler;
import org.wildfly.extension.picketlink.federation.model.sp.ServiceProviderRemoveHandler;
import org.wildfly.extension.picketlink.federation.service.ServiceProviderService;

public class ServiceProviderResourceDefinition
extends AbstractFederationResourceDefinition {
    public static final SimpleAttributeDefinition SECURITY_DOMAIN = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(ModelElement.COMMON_SECURITY_DOMAIN.getName(), ModelType.STRING, false).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.SECURITY_DOMAIN_REF})).build();
    public static final SimpleAttributeDefinition URL = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(ModelElement.COMMON_URL.getName(), ModelType.STRING, false).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition POST_BINDING = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(ModelElement.SERVICE_PROVIDER_POST_BINDING.getName(), ModelType.BOOLEAN, true).setDefaultValue(new ModelNode(true))).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition SUPPORT_SIGNATURES = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(ModelElement.COMMON_SUPPORTS_SIGNATURES.getName(), ModelType.BOOLEAN, true).setDefaultValue(new ModelNode(false))).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition SUPPORT_METADATA = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(ModelElement.COMMON_SUPPORT_METADATA.getName(), ModelType.BOOLEAN, true).setDefaultValue(new ModelNode(false))).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition STRICT_POST_BINDING = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(ModelElement.COMMON_STRICT_POST_BINDING.getName(), ModelType.BOOLEAN, true).setDefaultValue(new ModelNode(true))).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition ERROR_PAGE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(ModelElement.SERVICE_PROVIDER_ERROR_PAGE.getName(), ModelType.STRING, true).setDefaultValue(new ModelNode("/error.jsp"))).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition LOGOUT_PAGE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(ModelElement.SERVICE_PROVIDER_LOGOUT_PAGE.getName(), ModelType.STRING, true).setDefaultValue(new ModelNode("/logout.jsp"))).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition[] ATTRIBUTE_DEFINITIONS = new SimpleAttributeDefinition[]{SECURITY_DOMAIN, URL, POST_BINDING, SUPPORT_SIGNATURES, SUPPORT_METADATA, STRICT_POST_BINDING, ERROR_PAGE, LOGOUT_PAGE};
    private final ExtensionContext extensionContext;

    public ServiceProviderResourceDefinition(ExtensionContext extensionContext) {
        super(ModelElement.SERVICE_PROVIDER, (OperationStepHandler)ServiceProviderAddHandler.INSTANCE, (OperationStepHandler)ServiceProviderRemoveHandler.INSTANCE, ATTRIBUTE_DEFINITIONS);
        this.extensionContext = extensionContext;
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        this.addChildResourceDefinition(HandlerResourceDefinition.INSTANCE, resourceRegistration);
    }

    @Override
    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        if (this.extensionContext.isRuntimeOnlyRegistrationValid()) {
            for (SimpleAttributeDefinition def : ServiceProviderMetricsOperationHandler.ATTRIBUTES) {
                resourceRegistration.registerMetric((AttributeDefinition)def, (OperationStepHandler)ServiceProviderMetricsOperationHandler.INSTANCE);
            }
        }
    }

    @Override
    protected OperationStepHandler createAttributeWriterHandler() {
        List<SimpleAttributeDefinition> attributes = this.getAttributes();
        return new RestartParentWriteAttributeHandler(ModelElement.SERVICE_PROVIDER.getName(), attributes.toArray(new AttributeDefinition[attributes.size()])){

            protected ServiceName getParentServiceName(PathAddress parentAddress) {
                return ServiceProviderService.createServiceName(parentAddress.getLastElement().getValue());
            }

            protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel) throws OperationFailedException {
                ServiceProviderAddHandler.launchService(context, parentAddress, parentModel);
            }
        };
    }
}

