/*
 * Decompiled with CFR 0.152.
 */
package org.kie.soup.commons.util;

import java.util.ArrayList;
import java.util.List;

class InnerSplitter {
    private final List<String> result = new ArrayList<String>();
    private final String quoteCharacter;
    private String current = null;

    InnerSplitter(String quoteCharacter, boolean trim, String[] split) {
        this.quoteCharacter = quoteCharacter;
        for (String item : split) {
            if (this.current == null) {
                if (item.trim().startsWith(this.quoteCharacter) && item.trim().endsWith(this.quoteCharacter)) {
                    if (item.length() == 1) {
                        this.result.add(item);
                        continue;
                    }
                    this.result.add(item.substring(item.indexOf(this.quoteCharacter) + 1, item.lastIndexOf(this.quoteCharacter)));
                    continue;
                }
                if (item.trim().startsWith(this.quoteCharacter)) {
                    this.current = item.substring(item.indexOf(this.quoteCharacter) + 1) + ",";
                    continue;
                }
                if (trim) {
                    this.result.add(item.trim());
                    continue;
                }
                this.result.add(item);
                continue;
            }
            if (item.trim().endsWith(this.quoteCharacter)) {
                this.current = this.current + item.substring(0, item.lastIndexOf(this.quoteCharacter));
                this.result.add(this.current);
                this.current = null;
                continue;
            }
            this.current = this.current + item + ",";
        }
    }

    String[] getSplit() {
        return this.result.toArray(new String[this.result.size()]);
    }
}

