/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.transaction;

import io.undertow.client.ClientRequest;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import java.io.Closeable;
import java.io.OutputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLContext;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.xa.Xid;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Marshalling;
import org.wildfly.httpclient.common.HttpTargetContext;
import org.wildfly.httpclient.transaction.HttpRemoteTransactionMessages;
import org.wildfly.httpclient.transaction.HttpRemoteTransactionPeer;
import org.wildfly.httpclient.transaction.XidProvider;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.transaction.client.spi.SimpleTransactionControl;
import org.xnio.IoUtils;

class HttpRemoteTransactionHandle
implements SimpleTransactionControl {
    private final HttpTargetContext targetContext;
    private final AtomicInteger statusRef = new AtomicInteger(0);
    private final Xid id;
    private final SSLContext sslContext;
    private final AuthenticationConfiguration authenticationConfiguration;

    HttpRemoteTransactionHandle(Xid id, HttpTargetContext targetContext, SSLContext sslContext, AuthenticationConfiguration authenticationConfiguration) {
        this.id = id;
        this.targetContext = targetContext;
        this.sslContext = sslContext;
        this.authenticationConfiguration = authenticationConfiguration;
    }

    Xid getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException {
        AtomicInteger statusRef = this.statusRef;
        int oldVal = statusRef.get();
        if (oldVal != 0 && oldVal != 1) {
            throw HttpRemoteTransactionMessages.MESSAGES.invalidTxnState();
        }
        AtomicInteger atomicInteger = statusRef;
        synchronized (atomicInteger) {
            oldVal = statusRef.get();
            if (oldVal == 1) {
                this.rollback();
                throw HttpRemoteTransactionMessages.MESSAGES.rollbackOnlyRollback();
            }
            if (oldVal != 0) {
                throw HttpRemoteTransactionMessages.MESSAGES.invalidTxnState();
            }
            CompletableFuture result = new CompletableFuture();
            statusRef.set(8);
            ClientRequest cr = new ClientRequest().setMethod(Methods.POST).setPath(this.targetContext.getUri().getPath() + "/txn/v1/ut/commit");
            cr.getRequestHeaders().put(Headers.ACCEPT, "application/x-wf-jbmar-exception;version=1");
            cr.getRequestHeaders().put(Headers.CONTENT_TYPE, "application/x-wf-jbmar-xid;version=1");
            this.targetContext.sendRequest(cr, this.sslContext, this.authenticationConfiguration, output -> {
                Marshaller marshaller = this.targetContext.createMarshaller(HttpRemoteTransactionPeer.createMarshallingConf());
                marshaller.start(Marshalling.createByteOutput((OutputStream)output));
                marshaller.writeInt(this.id.getFormatId());
                byte[] gtid = this.id.getGlobalTransactionId();
                marshaller.writeInt(gtid.length);
                marshaller.write(gtid);
                byte[] bq = this.id.getBranchQualifier();
                marshaller.writeInt(bq.length);
                marshaller.write(bq);
                marshaller.finish();
                output.close();
            }, (input, response, closable) -> {
                try {
                    result.complete(null);
                }
                finally {
                    IoUtils.safeClose((Closeable)closable);
                }
            }, result::completeExceptionally, null, null);
            try {
                result.get();
                statusRef.set(3);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                statusRef.set(5);
                throw HttpRemoteTransactionMessages.MESSAGES.operationInterrupted();
            }
            catch (ExecutionException e) {
                try {
                    throw e.getCause();
                }
                catch (RollbackException ex) {
                    statusRef.set(4);
                    throw ex;
                }
                catch (SecurityException ex) {
                    statusRef.set(oldVal);
                    throw ex;
                }
                catch (HeuristicMixedException | HeuristicRollbackException | SystemException ex) {
                    statusRef.set(5);
                    throw ex;
                }
                catch (Throwable throwable) {
                    SystemException ex = new SystemException(throwable.getMessage());
                    statusRef.set(5);
                    ex.initCause(throwable);
                    throw ex;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws SecurityException, SystemException {
        AtomicInteger statusRef = this.statusRef;
        int oldVal = statusRef.get();
        if (oldVal != 0 && oldVal != 1) {
            throw HttpRemoteTransactionMessages.MESSAGES.invalidTxnState();
        }
        AtomicInteger atomicInteger = statusRef;
        synchronized (atomicInteger) {
            oldVal = statusRef.get();
            if (oldVal != 0 && oldVal != 1) {
                throw HttpRemoteTransactionMessages.MESSAGES.invalidTxnState();
            }
            statusRef.set(9);
            CompletableFuture result = new CompletableFuture();
            statusRef.set(8);
            ClientRequest cr = new ClientRequest().setMethod(Methods.POST).setPath(this.targetContext.getUri().getPath() + "/txn/v1/ut/rollback");
            cr.getRequestHeaders().put(Headers.ACCEPT, "application/x-wf-jbmar-exception;version=1");
            cr.getRequestHeaders().put(Headers.CONTENT_TYPE, "application/x-wf-jbmar-xid;version=1");
            this.targetContext.sendRequest(cr, this.sslContext, this.authenticationConfiguration, output -> {
                Marshaller marshaller = this.targetContext.createMarshaller(HttpRemoteTransactionPeer.createMarshallingConf());
                marshaller.start(Marshalling.createByteOutput((OutputStream)output));
                marshaller.writeInt(this.id.getFormatId());
                byte[] gtid = this.id.getGlobalTransactionId();
                marshaller.writeInt(gtid.length);
                marshaller.write(gtid);
                byte[] bq = this.id.getBranchQualifier();
                marshaller.writeInt(bq.length);
                marshaller.write(bq);
                marshaller.finish();
                output.close();
            }, (input, response, closeable) -> {
                try {
                    result.complete(null);
                }
                finally {
                    IoUtils.safeClose((Closeable)closeable);
                }
            }, result::completeExceptionally, null, null);
            try {
                result.get();
                statusRef.set(4);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                statusRef.set(5);
                throw HttpRemoteTransactionMessages.MESSAGES.operationInterrupted();
            }
            catch (ExecutionException e) {
                try {
                    throw e.getCause();
                }
                catch (SecurityException ex) {
                    statusRef.set(oldVal);
                    throw ex;
                }
                catch (SystemException ex) {
                    statusRef.set(5);
                    throw ex;
                }
                catch (Throwable throwable) {
                    SystemException ex = new SystemException(throwable.getMessage());
                    statusRef.set(5);
                    ex.initCause(throwable);
                    throw ex;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRollbackOnly() throws SystemException {
        AtomicInteger statusRef = this.statusRef;
        int oldVal = statusRef.get();
        if (oldVal == 1) {
            return;
        }
        if (oldVal != 0) {
            throw HttpRemoteTransactionMessages.MESSAGES.invalidTxnState();
        }
        AtomicInteger atomicInteger = statusRef;
        synchronized (atomicInteger) {
            oldVal = statusRef.get();
            if (oldVal == 1) {
                return;
            }
            if (oldVal != 0) {
                throw HttpRemoteTransactionMessages.MESSAGES.invalidTxnState();
            }
            statusRef.set(1);
        }
    }

    public <T> T getProviderInterface(Class<T> providerInterfaceType) {
        if (providerInterfaceType == XidProvider.class) {
            return (T)((XidProvider)() -> this.id);
        }
        return null;
    }
}

