/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import java.lang.reflect.Type;
import javax.json.bind.JsonbException;
import javax.json.bind.serializer.DeserializationContext;
import javax.json.stream.JsonParser;
import org.eclipse.yasson.internal.JsonbParser;
import org.eclipse.yasson.internal.model.JsonBindingModel;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;
import org.eclipse.yasson.internal.serializer.AbstractValueTypeDeserializer;

public class BooleanTypeDeserializer
extends AbstractValueTypeDeserializer<Boolean> {
    public BooleanTypeDeserializer(JsonBindingModel model) {
        super(Boolean.class, model);
    }

    @Override
    public Boolean deserialize(JsonParser parser, DeserializationContext ctx, Type rtType) {
        JsonParser.Event event = ((JsonbParser)parser).moveToValue();
        switch (event) {
            case VALUE_TRUE: {
                return Boolean.TRUE;
            }
            case VALUE_FALSE: {
                return Boolean.FALSE;
            }
            case VALUE_STRING: {
                return Boolean.parseBoolean(parser.getString());
            }
        }
        throw new JsonbException(Messages.getMessage(MessageKeys.INTERNAL_ERROR, "Unknown JSON value: " + event));
    }
}

