/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import java.lang.reflect.Type;
import javax.json.bind.JsonbException;
import org.eclipse.yasson.internal.Unmarshaller;
import org.eclipse.yasson.internal.model.JsonBindingModel;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;
import org.eclipse.yasson.internal.serializer.AbstractNumberDeserializer;

public class ByteTypeDeserializer
extends AbstractNumberDeserializer<Byte> {
    public ByteTypeDeserializer(JsonBindingModel model) {
        super(Byte.class, model);
    }

    @Override
    protected Byte deserialize(String value, Unmarshaller unmarshaller, Type rtType) {
        return this.deserializeFormatted(value, true, unmarshaller.getJsonbContext()).map(num -> Byte.parseByte(num.toString())).orElseGet(() -> {
            try {
                return Byte.parseByte(value);
            }
            catch (NumberFormatException e) {
                throw new JsonbException(Messages.getMessage(MessageKeys.DESERIALIZE_VALUE_ERROR, Byte.class));
            }
        });
    }
}

