/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.job.model;

import java.util.List;
import javax.batch.operations.JobStartException;
import org.jberet._private.BatchLogger;
import org.jberet.creation.ArchiveXmlLoader;
import org.jberet.job.model.AbstractMerger;
import org.jberet.job.model.Chunk;
import org.jberet.job.model.InheritableJobElement;
import org.jberet.job.model.Job;
import org.jberet.job.model.JobElement;
import org.jberet.job.model.Partition;
import org.jberet.job.model.PropertiesHolder;
import org.jberet.job.model.RefArtifact;
import org.jberet.job.model.Step;
import org.jberet.spi.JobXmlResolver;

public final class StepMerger
extends AbstractMerger<Step> {
    StepMerger(Job job, Step child, ClassLoader classLoader, List<Job> loadedJobs, JobXmlResolver jobXmlResolver) throws JobStartException {
        super(job, classLoader, loadedJobs, jobXmlResolver);
        this.child = child;
        String parentName = child.getParent();
        String jslName = child.getJslName();
        if (jslName == null || jslName.equals("*") || jslName.equals(job.id)) {
            for (JobElement e : job.getJobElements()) {
                if (!parentName.equals(e.getId())) continue;
                this.parent = (Step)e;
                break;
            }
        } else {
            Job jobOfParentStep = ArchiveXmlLoader.loadJobXml(jslName, classLoader, loadedJobs, jobXmlResolver);
            for (JobElement e : jobOfParentStep.getJobElements()) {
                if (!parentName.equals(e.getId())) continue;
                this.parent = (Step)e;
            }
        }
    }

    public void merge() throws JobStartException {
        this.checkInheritingElements((Step)this.parent, ((Step)this.parent).getId());
        if (((Step)this.parent).getParent() != null) {
            StepMerger merger2 = new StepMerger(this.currentJob, (Step)this.parent, this.classLoader, this.loadedJobs, this.jobXmlResolver);
            this.recordInheritingElements(merger2);
            merger2.merge();
        }
        if (((Step)this.child).getAttributeNext() == null) {
            ((Step)this.child).setAttributeNext(((Step)this.parent).getAttributeNext());
        }
        if (((Step)this.child).getStartLimit() == null) {
            ((Step)this.child).setStartLimit(((Step)this.parent).getStartLimit());
        }
        if (((Step)this.child).getAllowStartIfComplete() == null) {
            ((Step)this.child).setAllowStartIfComplete(((Step)this.parent).getAllowStartIfComplete());
        }
        StepMerger.mergeProperties((PropertiesHolder)((Object)this.parent), (PropertiesHolder)((Object)this.child));
        StepMerger.mergeListeners((InheritableJobElement)this.parent, (InheritableJobElement)this.child);
        RefArtifact parentBatchlet = ((Step)this.parent).getBatchlet();
        RefArtifact childBatchlet = ((Step)this.child).getBatchlet();
        Chunk parentChunk = ((Step)this.parent).getChunk();
        Chunk childChunk = ((Step)this.child).getChunk();
        if (childChunk != null && childBatchlet == null) {
            if (parentChunk != null) {
                this.mergeChunk(parentChunk, childChunk);
            }
        } else if (childChunk != null || childBatchlet == null) {
            if (childChunk == null) {
                if (parentChunk != null) {
                    ((Step)this.child).setChunk(parentChunk.clone());
                } else if (parentBatchlet != null) {
                    ((Step)this.child).setBatchlet(parentBatchlet.clone());
                }
            } else {
                BatchLogger.LOGGER.cannotContainBothChunkAndBatchlet(((Step)this.child).getId());
                throw new JobStartException();
            }
        }
        Partition parentPartition = ((Step)this.parent).getPartition();
        if (((Step)this.child).getPartition() == null && parentPartition != null) {
            ((Step)this.child).setPartition(parentPartition.clone());
        }
        ((Step)this.child).setParentAndJslName(null, null);
    }

    private void mergeChunk(Chunk parentChunk, Chunk childChunk) {
        if (childChunk.checkpointPolicy == null && parentChunk.checkpointPolicy != null) {
            childChunk.checkpointPolicy = parentChunk.checkpointPolicy;
        }
        if (childChunk.skipLimit == null && parentChunk.skipLimit != null) {
            childChunk.skipLimit = parentChunk.skipLimit;
        }
        if (childChunk.retryLimit == null && parentChunk.retryLimit != null) {
            childChunk.retryLimit = parentChunk.retryLimit;
        }
        if (childChunk.itemCount == null && parentChunk.itemCount != null) {
            childChunk.itemCount = parentChunk.itemCount;
        }
        if (childChunk.timeLimit == null && parentChunk.timeLimit != null) {
            childChunk.timeLimit = parentChunk.timeLimit;
        }
        if (childChunk.reader == null && parentChunk.reader != null) {
            childChunk.reader = parentChunk.reader.clone();
        }
        if (childChunk.writer == null && parentChunk.writer != null) {
            childChunk.writer = parentChunk.writer.clone();
        }
        if (childChunk.processor == null && parentChunk.processor != null) {
            childChunk.processor = parentChunk.processor.clone();
        }
        if (childChunk.checkpointAlgorithm == null && parentChunk.checkpointAlgorithm != null) {
            childChunk.checkpointAlgorithm = parentChunk.checkpointAlgorithm.clone();
        }
        if (parentChunk.skippableExceptionClasses != null) {
            if (childChunk.skippableExceptionClasses == null) {
                childChunk.skippableExceptionClasses = parentChunk.skippableExceptionClasses.clone();
            } else if (childChunk.skippableExceptionClasses.isMerge()) {
                childChunk.skippableExceptionClasses.include.addAll(parentChunk.skippableExceptionClasses.include);
                childChunk.skippableExceptionClasses.exclude.addAll(parentChunk.skippableExceptionClasses.exclude);
            }
        }
        if (parentChunk.retryableExceptionClasses != null) {
            if (childChunk.retryableExceptionClasses == null) {
                childChunk.retryableExceptionClasses = parentChunk.retryableExceptionClasses.clone();
            } else if (childChunk.retryableExceptionClasses.isMerge()) {
                childChunk.retryableExceptionClasses.include.addAll(parentChunk.retryableExceptionClasses.include);
                childChunk.retryableExceptionClasses.exclude.addAll(parentChunk.retryableExceptionClasses.exclude);
            }
        }
        if (parentChunk.noRollbackExceptionClasses != null) {
            if (childChunk.noRollbackExceptionClasses == null) {
                childChunk.noRollbackExceptionClasses = parentChunk.noRollbackExceptionClasses.clone();
            } else if (childChunk.noRollbackExceptionClasses.isMerge()) {
                childChunk.noRollbackExceptionClasses.include.addAll(parentChunk.noRollbackExceptionClasses.include);
                childChunk.noRollbackExceptionClasses.exclude.addAll(parentChunk.noRollbackExceptionClasses.exclude);
            }
        }
    }
}

