/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.commons.access;

import org.hibernate.cache.CacheException;
import org.infinispan.AdvancedCache;
import org.infinispan.hibernate.cache.commons.InfinispanDataRegion;
import org.infinispan.hibernate.cache.commons.access.AccessDelegate;
import org.infinispan.hibernate.cache.commons.access.PutFromLoadValidator;
import org.infinispan.hibernate.cache.commons.util.Caches;
import org.infinispan.hibernate.cache.commons.util.InfinispanMessageLogger;

public abstract class InvalidationCacheAccessDelegate
implements AccessDelegate {
    protected static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(InvalidationCacheAccessDelegate.class);
    protected static final boolean TRACE_ENABLED = log.isTraceEnabled();
    protected final AdvancedCache cache;
    protected final InfinispanDataRegion region;
    protected final PutFromLoadValidator putValidator;
    protected final AdvancedCache<Object, Object> writeCache;

    protected InvalidationCacheAccessDelegate(InfinispanDataRegion region, PutFromLoadValidator validator) {
        this.region = region;
        this.cache = region.getCache();
        this.putValidator = validator;
        this.writeCache = Caches.ignoreReturnValuesCache(this.cache);
    }

    @Override
    public Object get(Object session, Object key, long txTimestamp) throws CacheException {
        if (!this.region.checkValid()) {
            return null;
        }
        Object val = this.cache.get(key);
        if (val == null && session != null) {
            this.putValidator.registerPendingPut(session, key, txTimestamp);
        }
        return val;
    }

    @Override
    public boolean putFromLoad(Object session, Object key, Object value, long txTimestamp, Object version) {
        return this.putFromLoad(session, key, value, txTimestamp, version, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean putFromLoad(Object session, Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) throws CacheException {
        if (!this.region.checkValid()) {
            if (TRACE_ENABLED) {
                log.tracef("Region %s not valid", this.region.getName());
            }
            return false;
        }
        if (minimalPutOverride && this.cache.containsKey(key)) {
            return false;
        }
        PutFromLoadValidator.Lock lock = this.putValidator.acquirePutFromLoadLock(session, key, txTimestamp);
        if (lock == null) {
            if (TRACE_ENABLED) {
                log.tracef("Put from load lock not acquired for key %s", key);
            }
            return false;
        }
        try {
            this.writeCache.putForExternalRead(key, value);
        }
        finally {
            this.putValidator.releasePutFromLoadLock(key, lock);
        }
        return true;
    }

    @Override
    public void remove(Object session, Object key) throws CacheException {
        this.writeCache.remove(key);
    }

    @Override
    public void removeAll() throws CacheException {
        try {
            if (!this.putValidator.beginInvalidatingRegion()) {
                log.failedInvalidateRegion(this.region.getName());
            }
            Caches.removeAll(this.cache);
        }
        finally {
            this.putValidator.endInvalidatingRegion();
        }
    }

    @Override
    public void evict(Object key) throws CacheException {
        this.writeCache.remove(key);
    }

    @Override
    public void evictAll() throws CacheException {
        try {
            if (!this.putValidator.beginInvalidatingRegion()) {
                log.failedInvalidateRegion(this.region.getName());
            }
            this.region.invalidateRegion();
            Caches.broadcastEvictAll(this.cache);
        }
        finally {
            this.putValidator.endInvalidatingRegion();
        }
    }

    @Override
    public void unlockItem(Object session, Object key) throws CacheException {
    }
}

