/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.security.impl.InMemorySingleSignOnManager;
import io.undertow.security.impl.SingleSignOnManager;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.SimpleCapabilityServiceConfigurator;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.controller.CapabilityServiceTarget;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.HostDefinition;
import org.wildfly.extension.undertow.HostSingleSignOnDefinition;
import org.wildfly.extension.undertow.SingleSignOnDefinition;
import org.wildfly.extension.undertow.SingleSignOnService;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.security.sso.DistributableHostSingleSignOnManagerServiceConfiguratorProvider;

class HostSingleSignOnServiceHandler
implements ResourceServiceHandler {
    HostSingleSignOnServiceHandler() {
    }

    public void installServices(OperationContext context, ModelNode model) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        PathAddress hostAddress = address.getParent();
        PathAddress serverAddress = hostAddress.getParent();
        String hostName = hostAddress.getLastElement().getValue();
        String serverName = serverAddress.getLastElement().getValue();
        String domain = ModelNodes.optionalString((ModelNode)SingleSignOnDefinition.Attribute.DOMAIN.resolveModelAttribute((ExpressionResolver)context, model)).orElse(null);
        String path = SingleSignOnDefinition.Attribute.PATH.resolveModelAttribute((ExpressionResolver)context, model).asString();
        boolean secure = SingleSignOnDefinition.Attribute.SECURE.resolveModelAttribute((ExpressionResolver)context, model).asBoolean();
        boolean httpOnly = SingleSignOnDefinition.Attribute.HTTP_ONLY.resolveModelAttribute((ExpressionResolver)context, model).asBoolean();
        String cookieName = SingleSignOnDefinition.Attribute.COOKIE_NAME.resolveModelAttribute((ExpressionResolver)context, model).asString();
        ServiceName serviceName = UndertowService.ssoServiceName(serverName, hostName);
        ServiceName virtualHostServiceName = HostDefinition.HOST_CAPABILITY.getCapabilityServiceName(new String[]{serverName, hostName});
        CapabilityServiceTarget target = context.getCapabilityServiceTarget();
        ServiceName managerServiceName = serviceName.append(new String[]{"manager"});
        DistributableHostSingleSignOnManagerServiceConfiguratorProvider.INSTANCE.map(provider -> provider.getServiceConfigurator(managerServiceName, serverName, hostName)).orElse((CapabilityServiceConfigurator)new SimpleCapabilityServiceConfigurator(managerServiceName, (Object)new InMemorySingleSignOnManager())).configure(context).build((ServiceTarget)target).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        SingleSignOnService service = new SingleSignOnService(domain, path, httpOnly, secure, cookieName);
        target.addCapability(HostSingleSignOnDefinition.HOST_SSO_CAPABILITY, (Service)service).addAliases(new ServiceName[]{serviceName}).addDependency(virtualHostServiceName, Host.class, service.getHost()).addDependency(managerServiceName, SingleSignOnManager.class, service.getSingleSignOnSessionManager()).setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    public void removeServices(OperationContext context, ModelNode model) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        PathAddress hostAddress = address.getParent();
        PathAddress serverAddress = hostAddress.getParent();
        String hostName = hostAddress.getLastElement().getValue();
        String serverName = serverAddress.getLastElement().getValue();
        ServiceName serviceName = UndertowService.ssoServiceName(serverName, hostName);
        context.removeService(serviceName.append(new String[]{"manager"}));
        context.removeService(HostSingleSignOnDefinition.HOST_SSO_CAPABILITY.getCapabilityServiceName(address));
    }
}

