/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.session;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.SessionConfig;
import io.undertow.util.AttachmentKey;
import org.jboss.as.web.session.SessionIdentifierCodec;

public class CodecSessionConfig
implements SessionConfig {
    private final SessionConfig config;
    private final SessionIdentifierCodec codec;
    private static final AttachmentKey<Boolean> SESSION_ID_SET = AttachmentKey.create(Boolean.class);

    public CodecSessionConfig(SessionConfig config, SessionIdentifierCodec codec) {
        this.config = config;
        this.codec = codec;
    }

    public void setSessionId(HttpServerExchange exchange, String sessionId) {
        exchange.putAttachment(SESSION_ID_SET, (Object)Boolean.TRUE);
        this.config.setSessionId(exchange, this.codec.encode(sessionId));
    }

    public void clearSession(HttpServerExchange exchange, String sessionId) {
        this.config.clearSession(exchange, this.codec.encode(sessionId));
    }

    public String findSessionId(HttpServerExchange exchange) {
        String encodedSessionId = this.config.findSessionId(exchange);
        if (encodedSessionId == null) {
            return null;
        }
        String sessionId = this.codec.decode(encodedSessionId);
        String reencodedSessionId = this.codec.encode(sessionId);
        if (!reencodedSessionId.equals(encodedSessionId) && exchange.getAttachment(SESSION_ID_SET) == null) {
            this.config.setSessionId(exchange, reencodedSessionId);
        }
        return sessionId;
    }

    public SessionConfig.SessionCookieSource sessionCookieSource(HttpServerExchange exchange) {
        return this.config.sessionCookieSource(exchange);
    }

    public String rewriteUrl(String originalUrl, String sessionId) {
        return this.config.rewriteUrl(originalUrl, this.codec.encode(sessionId));
    }
}

