/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.sse;

import java.io.IOException;
import java.lang.reflect.Method;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.sse.SseEventSink;
import org.jboss.resteasy.annotations.Stream;
import org.jboss.resteasy.core.PostResourceMethodInvoker;
import org.jboss.resteasy.core.PostResourceMethodInvokers;
import org.jboss.resteasy.core.interception.PostMatchContainerRequestContext;
import org.jboss.resteasy.plugins.providers.sse.SseEventOutputImpl;
import org.jboss.resteasy.plugins.providers.sse.SseEventProvider;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

@Provider
@Priority(value=0x7FFFFFFF)
public class SseEventSinkInterceptor
implements ContainerRequestFilter {
    public void filter(ContainerRequestContext requestContext) throws IOException {
        Method method = ((PostMatchContainerRequestContext)requestContext).getResourceMethod().getMethod();
        Stream stream = method.getAnnotation(Stream.class);
        Stream.MODE mode = stream != null ? stream.value() : null;
        Class<?> clazz = method.getReturnType();
        if (mode == Stream.MODE.GENERAL && ResteasyProviderFactory.getInstance().getAsyncStreamProvider(clazz) != null || requestContext instanceof PostMatchContainerRequestContext && ((PostMatchContainerRequestContext)requestContext).getResourceMethod().isSse()) {
            final SseEventOutputImpl sink = new SseEventOutputImpl(new SseEventProvider());
            ResteasyProviderFactory.getContextDataMap().put(SseEventSink.class, (Object)sink);
            ResteasyProviderFactory.getContextData(PostResourceMethodInvokers.class).addInvokers(new PostResourceMethodInvoker(){

                @Override
                public void invoke() {
                    sink.flushResponseToClient();
                }
            });
        }
    }
}

