/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.counter.impl;

import java.util.concurrent.CompletableFuture;
import org.infinispan.client.hotrod.counter.impl.CounterOperationFactory;
import org.infinispan.client.hotrod.counter.impl.NotificationManager;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterListener;
import org.infinispan.counter.api.Handle;

public class BaseCounter {
    protected final String name;
    protected final CounterConfiguration configuration;
    protected final CounterOperationFactory factory;
    protected final NotificationManager notificationManager;

    public BaseCounter(CounterConfiguration configuration, String name, CounterOperationFactory factory, NotificationManager notificationManager) {
        this.configuration = configuration;
        this.name = name;
        this.factory = factory;
        this.notificationManager = notificationManager;
    }

    public String getName() {
        return this.name;
    }

    public CompletableFuture<Void> reset() {
        return this.factory.newResetOperation(this.name).execute();
    }

    public CompletableFuture<Void> remove() {
        return this.factory.newRemoveOperation(this.name).execute();
    }

    public CounterConfiguration getConfiguration() {
        return this.configuration;
    }

    public <T extends CounterListener> Handle<T> addListener(T listener) {
        return this.notificationManager.addListener(this.name, listener);
    }
}

