/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.common.properties;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import org.picketlink.common.properties.FieldProperty;
import org.picketlink.common.reflection.Reflections;

class FieldPropertyImpl<V>
implements FieldProperty<V> {
    private final Field field;

    FieldPropertyImpl(Field field) {
        this.field = field;
    }

    @Override
    public String getName() {
        return this.field.getName();
    }

    @Override
    public Type getBaseType() {
        return this.field.getGenericType();
    }

    @Override
    public Field getAnnotatedElement() {
        return this.field;
    }

    @Override
    public Member getMember() {
        return this.field;
    }

    @Override
    public Class<V> getJavaClass() {
        return this.field.getType();
    }

    @Override
    public V getValue(Object instance) {
        this.setAccessible();
        return Reflections.getFieldValue(this.field, instance, this.getJavaClass());
    }

    @Override
    public void setValue(Object instance, V value) {
        this.setAccessible();
        Reflections.setFieldValue(true, this.field, instance, value);
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.field.getDeclaringClass();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void setAccessible() {
        Reflections.setAccessible(this.field);
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotation) {
        return this.getAnnotatedElement() != null && this.getAnnotatedElement().isAnnotationPresent(annotation);
    }

    public String toString() {
        return this.field.toString();
    }

    public int hashCode() {
        return this.field.hashCode();
    }

    public boolean equals(Object obj) {
        return this.field.equals(obj);
    }
}

