/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.forms;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import org.keycloak.Config;
import org.keycloak.authentication.FormAction;
import org.keycloak.authentication.FormActionFactory;
import org.keycloak.authentication.FormContext;
import org.keycloak.authentication.ValidationContext;
import org.keycloak.events.EventType;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.services.resources.AttributeFormDataProcessor;
import org.keycloak.services.validation.Validation;

public class RegistrationUserCreation
implements FormAction,
FormActionFactory {
    public static final String PROVIDER_ID = "registration-user-creation";
    private static AuthenticationExecutionModel.Requirement[] REQUIREMENT_CHOICES = new AuthenticationExecutionModel.Requirement[]{AuthenticationExecutionModel.Requirement.REQUIRED, AuthenticationExecutionModel.Requirement.DISABLED};

    public String getHelpText() {
        return "This action must always be first! Validates the username of the user in validation phase.  In success phase, this will create the user in the database.";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return null;
    }

    public void validate(ValidationContext context) {
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        ArrayList<FormMessage> errors = new ArrayList<FormMessage>();
        context.getEvent().detail("register_method", "form");
        String email = (String)formData.getFirst((Object)"email");
        String username = (String)formData.getFirst((Object)"username");
        context.getEvent().detail("username", username);
        context.getEvent().detail("email", email);
        String usernameField = "username";
        if (context.getRealm().isRegistrationEmailAsUsername()) {
            context.getEvent().detail("username", email);
            if (Validation.isBlank(email)) {
                errors.add(new FormMessage("email", "missingEmailMessage"));
            } else if (!Validation.isEmailValid(email)) {
                errors.add(new FormMessage("email", "invalidEmailMessage"));
                formData.remove((Object)"email");
            }
            if (errors.size() > 0) {
                context.error("invalid_registration");
                context.validationError(formData, errors);
                return;
            }
            if (email != null && !context.getRealm().isDuplicateEmailsAllowed() && context.getSession().users().getUserByEmail(email, context.getRealm()) != null) {
                context.error("email_in_use");
                formData.remove((Object)"email");
                errors.add(new FormMessage("email", "emailExistsMessage"));
                context.validationError(formData, errors);
                return;
            }
        } else {
            if (Validation.isBlank(username)) {
                context.error("invalid_registration");
                errors.add(new FormMessage("username", "missingUsernameMessage"));
                context.validationError(formData, errors);
                return;
            }
            if (context.getSession().users().getUserByUsername(username, context.getRealm()) != null) {
                context.error("username_in_use");
                errors.add(new FormMessage(usernameField, "usernameExistsMessage"));
                formData.remove((Object)"username");
                context.validationError(formData, errors);
                return;
            }
        }
        context.success();
    }

    public void buildPage(FormContext context, LoginFormsProvider form) {
    }

    public void success(FormContext context) {
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        String email = (String)formData.getFirst((Object)"email");
        String username = (String)formData.getFirst((Object)"username");
        if (context.getRealm().isRegistrationEmailAsUsername()) {
            username = (String)formData.getFirst((Object)"email");
        }
        context.getEvent().detail("username", username).detail("register_method", "form").detail("email", email);
        UserModel user = context.getSession().users().addUser(context.getRealm(), username);
        user.setEnabled(true);
        user.setEmail(email);
        context.getAuthenticationSession().setClientNote("login_hint", username);
        AttributeFormDataProcessor.process((MultivaluedMap<String, String>)formData, context.getRealm(), user);
        context.setUser(user);
        context.getEvent().user(user);
        context.getEvent().success();
        context.newEvent().event(EventType.LOGIN);
        context.getEvent().client(context.getAuthenticationSession().getClient().getClientId()).detail("redirect_uri", context.getAuthenticationSession().getRedirectUri()).detail("auth_method", context.getAuthenticationSession().getProtocol());
        String authType = context.getAuthenticationSession().getAuthNote("auth_type");
        if (authType != null) {
            context.getEvent().detail("auth_type", authType);
        }
    }

    public boolean requiresUser() {
        return false;
    }

    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return true;
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
    }

    public boolean isUserSetupAllowed() {
        return false;
    }

    public void close() {
    }

    public String getDisplayType() {
        return "Registration User Creation";
    }

    public String getReferenceCategory() {
        return null;
    }

    public boolean isConfigurable() {
        return false;
    }

    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return REQUIREMENT_CHOICES;
    }

    public FormAction create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getId() {
        return PROVIDER_ID;
    }
}

