/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.saml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.keycloak.broker.provider.DefaultDataMarshaller;
import org.keycloak.dom.saml.v2.assertion.AssertionType;
import org.keycloak.dom.saml.v2.assertion.AuthnStatementType;
import org.keycloak.dom.saml.v2.protocol.ResponseType;
import org.keycloak.saml.common.constants.GeneralConstants;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.common.util.StaxUtil;
import org.keycloak.saml.processing.core.parsers.saml.SAMLParser;
import org.keycloak.saml.processing.core.saml.v2.writers.SAMLAssertionWriter;
import org.keycloak.saml.processing.core.saml.v2.writers.SAMLResponseWriter;

public class SAMLDataMarshaller
extends DefaultDataMarshaller {
    public String serialize(Object obj) {
        if (obj.getClass().getName().startsWith("org.keycloak.dom.saml")) {
            ByteArrayOutputStream bos;
            block6: {
                bos = new ByteArrayOutputStream();
                try {
                    if (obj instanceof ResponseType) {
                        ResponseType responseType = (ResponseType)obj;
                        SAMLResponseWriter samlWriter = new SAMLResponseWriter(StaxUtil.getXMLStreamWriter((OutputStream)bos));
                        samlWriter.write(responseType, true);
                        break block6;
                    }
                    if (obj instanceof AssertionType) {
                        AssertionType assertion = (AssertionType)obj;
                        SAMLAssertionWriter samlWriter = new SAMLAssertionWriter(StaxUtil.getXMLStreamWriter((OutputStream)bos));
                        samlWriter.write(assertion, true);
                        break block6;
                    }
                    if (obj instanceof AuthnStatementType) {
                        AuthnStatementType authnStatement = (AuthnStatementType)obj;
                        SAMLAssertionWriter samlWriter = new SAMLAssertionWriter(StaxUtil.getXMLStreamWriter((OutputStream)bos));
                        samlWriter.write(authnStatement, true);
                        break block6;
                    }
                    throw new IllegalArgumentException("Don't know how to serialize object of type " + obj.getClass().getName());
                }
                catch (ProcessingException pe) {
                    throw new RuntimeException(pe);
                }
            }
            return new String(bos.toByteArray(), GeneralConstants.SAML_CHARSET);
        }
        return super.serialize(obj);
    }

    public <T> T deserialize(String serialized, Class<T> clazz) {
        if (clazz.getName().startsWith("org.keycloak.dom.saml")) {
            String xmlString = serialized;
            try {
                if (clazz.equals(ResponseType.class) || clazz.equals(AssertionType.class) || clazz.equals(AuthnStatementType.class)) {
                    byte[] bytes = xmlString.getBytes(GeneralConstants.SAML_CHARSET);
                    ByteArrayInputStream is = new ByteArrayInputStream(bytes);
                    Object respType = SAMLParser.getInstance().parse((InputStream)is);
                    return clazz.cast(respType);
                }
                throw new IllegalArgumentException("Don't know how to deserialize object of type " + clazz.getName());
            }
            catch (ParsingException pe) {
                throw new RuntimeException(pe);
            }
        }
        return (T)super.deserialize(serialized, clazz);
    }
}

