/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.activation;

import com.sun.corba.se.impl.activation.ServerCallback;
import com.sun.corba.se.spi.activation.Activator;
import com.sun.corba.se.spi.activation.ActivatorHelper;
import com.sun.corba.se.spi.activation.Server;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Date;
import java.util.Properties;
import org.omg.CORBA.ORB;

public class ServerMain {
    public static final int OK = 0;
    public static final int MAIN_CLASS_NOT_FOUND = 1;
    public static final int NO_MAIN_METHOD = 2;
    public static final int APPLICATION_ERROR = 3;
    public static final int UNKNOWN_ERROR = 4;
    public static final int NO_SERVER_ID = 5;
    public static final int REGISTRATION_FAILED = 6;
    private static final boolean debug = false;

    public static String printResult(int result) {
        switch (result) {
            case 0: {
                return "Server terminated normally";
            }
            case 1: {
                return "main class not found";
            }
            case 2: {
                return "no main method";
            }
            case 3: {
                return "application error";
            }
            case 5: {
                return "server ID not defined";
            }
            case 6: {
                return "server registration failed";
            }
        }
        return "unknown error";
    }

    private void redirectIOStreams() {
        try {
            String logDirName = System.getProperty("com.sun.CORBA.activation.DbDir") + System.getProperty("file.separator") + "logs" + System.getProperty("file.separator");
            File logDir = new File(logDirName);
            String server = System.getProperty("com.sun.CORBA.POA.ORBServerId");
            FileOutputStream foutStream = new FileOutputStream(logDirName + server + ".out", true);
            FileOutputStream ferrStream = new FileOutputStream(logDirName + server + ".err", true);
            PrintStream pSout = new PrintStream(foutStream, true);
            PrintStream pSerr = new PrintStream(ferrStream, true);
            System.setOut(pSout);
            System.setErr(pSerr);
            ServerMain.logInformation("Server started");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void writeLogMessage(PrintStream pstream, String msg) {
        Date date = new Date();
        pstream.print("[" + date.toString() + "] " + msg + "\n");
    }

    public static void logInformation(String msg) {
        ServerMain.writeLogMessage(System.out, "        " + msg);
    }

    public static void logError(String msg) {
        ServerMain.writeLogMessage(System.out, "ERROR:  " + msg);
        ServerMain.writeLogMessage(System.err, "ERROR:  " + msg);
    }

    public static void logTerminal(String msg, int code) {
        if (code == 0) {
            ServerMain.writeLogMessage(System.out, "        " + msg);
        } else {
            ServerMain.writeLogMessage(System.out, "FATAL:  " + ServerMain.printResult(code) + ": " + msg);
            ServerMain.writeLogMessage(System.err, "FATAL:  " + ServerMain.printResult(code) + ": " + msg);
        }
        System.exit(code);
    }

    private Method getMainMethod(Class serverClass) {
        Class[] argTypes = new Class[]{String[].class};
        Method method = null;
        try {
            method = serverClass.getDeclaredMethod("main", argTypes);
        }
        catch (Exception exc) {
            ServerMain.logTerminal(exc.getMessage(), 2);
        }
        if (!this.isPublicStaticVoid(method)) {
            ServerMain.logTerminal("", 2);
        }
        return method;
    }

    private boolean isPublicStaticVoid(Method method) {
        int modifiers = method.getModifiers();
        if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers)) {
            ServerMain.logError(method.getName() + " is not public static");
            return false;
        }
        if (method.getExceptionTypes().length != 0) {
            ServerMain.logError(method.getName() + " declares exceptions");
            return false;
        }
        if (!method.getReturnType().equals(Void.TYPE)) {
            ServerMain.logError(method.getName() + " does not have a void return type");
            return false;
        }
        return true;
    }

    private Method getNamedMethod(Class serverClass, String methodName) {
        Class[] argTypes = new Class[]{ORB.class};
        Method method = null;
        try {
            method = serverClass.getDeclaredMethod(methodName, argTypes);
        }
        catch (Exception exc) {
            return null;
        }
        if (!this.isPublicStaticVoid(method)) {
            return null;
        }
        return method;
    }

    private void run(String[] args) {
        try {
            this.redirectIOStreams();
            String serverClassName = System.getProperty("com.sun.CORBA.POA.ORBServerName");
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = ClassLoader.getSystemClassLoader();
            }
            Class<?> serverClass = null;
            try {
                serverClass = Class.forName(serverClassName);
            }
            catch (ClassNotFoundException ex) {
                serverClass = Class.forName(serverClassName, true, cl);
            }
            Method mainMethod = this.getMainMethod(serverClass);
            boolean serverVerifyFlag = Boolean.getBoolean("com.sun.CORBA.activation.ORBServerVerify");
            if (serverVerifyFlag) {
                if (mainMethod == null) {
                    ServerMain.logTerminal("", 2);
                } else {
                    ServerMain.logTerminal("", 0);
                }
            }
            this.registerCallback(serverClass);
            Object[] params = new Object[]{args};
            mainMethod.invoke(null, params);
        }
        catch (ClassNotFoundException e) {
            ServerMain.logTerminal("ClassNotFound exception: " + e.getMessage(), 1);
        }
        catch (Exception e) {
            ServerMain.logTerminal("Exception: " + e.getMessage(), 3);
        }
    }

    public static void main(String[] args) {
        ServerMain server = new ServerMain();
        server.run(args);
    }

    private int getServerId() {
        Integer serverId = Integer.getInteger("com.sun.CORBA.POA.ORBServerId");
        if (serverId == null) {
            ServerMain.logTerminal("", 5);
        }
        return serverId;
    }

    private void registerCallback(Class serverClass) {
        Method installMethod = this.getNamedMethod(serverClass, "install");
        Method uninstallMethod = this.getNamedMethod(serverClass, "uninstall");
        Method shutdownMethod = this.getNamedMethod(serverClass, "shutdown");
        Properties props = new Properties();
        props.put("org.omg.CORBA.ORBClass", "com.sun.corba.se.impl.orb.ORBImpl");
        props.put("com.sun.CORBA.POA.ORBActivated", "false");
        String[] args = null;
        ORB orb = ORB.init(args, props);
        ServerCallback serverObj = new ServerCallback(orb, installMethod, uninstallMethod, shutdownMethod);
        int serverId = this.getServerId();
        try {
            Activator activator = ActivatorHelper.narrow(orb.resolve_initial_references("ServerActivator"));
            activator.active(serverId, (Server)((Object)serverObj));
        }
        catch (Exception ex) {
            ServerMain.logTerminal("exception " + ex.getMessage(), 6);
        }
    }
}

