/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem.remote;

import java.util.function.UnaryOperator;
import org.infinispan.client.hotrod.ProtocolVersion;
import org.jboss.as.clustering.controller.CapabilityProvider;
import org.jboss.as.clustering.controller.CapabilityReference;
import org.jboss.as.clustering.controller.ChildResourceDefinition;
import org.jboss.as.clustering.controller.ManagementResourceRegistration;
import org.jboss.as.clustering.controller.MetricExecutor;
import org.jboss.as.clustering.controller.MetricHandler;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceConfigurator;
import org.jboss.as.clustering.controller.ResourceServiceConfiguratorFactory;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.SimpleResourceRegistration;
import org.jboss.as.clustering.controller.UnaryRequirementCapability;
import org.jboss.as.clustering.controller.validation.EnumValidator;
import org.jboss.as.clustering.controller.validation.ModuleIdentifierValidatorBuilder;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanExtension;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanModel;
import org.jboss.as.clustering.infinispan.subsystem.ThreadPoolResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.remote.ConnectionPoolResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.remote.InvalidationNearCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.remote.NoNearCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.remote.RemoteCacheContainerConfigurationServiceConfigurator;
import org.jboss.as.clustering.infinispan.subsystem.remote.RemoteCacheContainerMetric;
import org.jboss.as.clustering.infinispan.subsystem.remote.RemoteCacheContainerMetricExecutor;
import org.jboss.as.clustering.infinispan.subsystem.remote.RemoteCacheContainerResource;
import org.jboss.as.clustering.infinispan.subsystem.remote.RemoteCacheContainerServiceHandler;
import org.jboss.as.clustering.infinispan.subsystem.remote.RemoteCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.remote.RemoteClusterResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.remote.RemoteTransactionResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.remote.SecurityResourceDefinition;
import org.jboss.as.controller.AbstractAttributeDefinitionBuilder;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.clustering.infinispan.client.InfinispanClientRequirement;
import org.wildfly.clustering.service.BinaryRequirement;
import org.wildfly.clustering.service.UnaryRequirement;

public class RemoteCacheContainerResourceDefinition
extends ChildResourceDefinition<ManagementResourceRegistration>
implements ResourceServiceConfiguratorFactory {
    public static final PathElement WILDCARD_PATH = RemoteCacheContainerResourceDefinition.pathElement("*");

    public static PathElement pathElement(String containerName) {
        return PathElement.pathElement((String)"remote-cache-container", (String)containerName);
    }

    public static void buildTransformation(ModelVersion version, ResourceTransformationDescriptionBuilder parent) {
        if (InfinispanModel.VERSION_7_0_0.requiresTransformation(version)) {
            parent.rejectChildResource(WILDCARD_PATH);
        } else {
            ResourceTransformationDescriptionBuilder builder = parent.addChildResource(WILDCARD_PATH);
            if (InfinispanModel.VERSION_11_0_0.requiresTransformation(version)) {
                ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(false, true, new ModelNode[]{ModelNode.FALSE}), new AttributeDefinition[]{Attribute.STATISTICS_ENABLED.getDefinition()})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{Attribute.STATISTICS_ENABLED.getDefinition()})).end();
            }
            if (InfinispanModel.VERSION_9_0_0.requiresTransformation(version)) {
                builder.getAttributeBuilder().setValueConverter((AttributeConverter)new AttributeConverter.DefaultValueAttributeConverter(Attribute.PROTOCOL_VERSION.getDefinition()), new AttributeDefinition[]{Attribute.PROTOCOL_VERSION.getDefinition()});
            }
            RemoteCacheContainerMetric.buildTransformation(version, builder);
            ConnectionPoolResourceDefinition.buildTransformation(version, builder);
            SecurityResourceDefinition.buildTransformation(version, builder);
            RemoteTransactionResourceDefinition.buildTransformation(version, builder);
            NoNearCacheResourceDefinition.buildTransformation(version, builder);
            InvalidationNearCacheResourceDefinition.buildTransformation(version, builder);
            RemoteClusterResourceDefinition.buildTransformation(version, builder);
            ThreadPoolResourceDefinition.CLIENT.buildTransformation(version, builder);
            RemoteCacheResourceDefinition.buildTransformation(version, builder);
        }
    }

    public RemoteCacheContainerResourceDefinition() {
        super(WILDCARD_PATH, InfinispanExtension.SUBSYSTEM_RESOLVER.createChildResolver(new PathElement[]{WILDCARD_PATH}));
    }

    public ManagementResourceRegistration register(ManagementResourceRegistration parentRegistration) {
        ManagementResourceRegistration registration = parentRegistration.registerSubModel((ResourceDefinition)this);
        ResourceDescriptor descriptor = new ResourceDescriptor(this.getResourceDescriptionResolver()).addAttributes(Attribute.class).addCapabilities(Capability.class).addRequiredChildren(new PathElement[]{ConnectionPoolResourceDefinition.PATH, ThreadPoolResourceDefinition.CLIENT.getPathElement(), SecurityResourceDefinition.PATH, RemoteTransactionResourceDefinition.PATH}).addRequiredSingletonChildren(new PathElement[]{NoNearCacheResourceDefinition.PATH}).setResourceTransformation(RemoteCacheContainerResource::new);
        RemoteCacheContainerServiceHandler handler = new RemoteCacheContainerServiceHandler(this);
        new SimpleResourceRegistration(descriptor, (ResourceServiceHandler)handler).register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        new ConnectionPoolResourceDefinition().register(registration);
        new RemoteClusterResourceDefinition(this).register(registration);
        new SecurityResourceDefinition().register(registration);
        new RemoteTransactionResourceDefinition().register(registration);
        new InvalidationNearCacheResourceDefinition().register(registration);
        new NoNearCacheResourceDefinition().register(registration);
        ThreadPoolResourceDefinition.CLIENT.register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        if (registration.isRuntimeOnlyRegistrationValid()) {
            new MetricHandler((MetricExecutor)new RemoteCacheContainerMetricExecutor(), RemoteCacheContainerMetric.class).register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
            new RemoteCacheResourceDefinition().register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        }
        return registration;
    }

    public ResourceServiceConfigurator createServiceConfigurator(PathAddress address) {
        return new RemoteCacheContainerConfigurationServiceConfigurator(address);
    }

    public static enum Attribute implements org.jboss.as.clustering.controller.Attribute,
    UnaryOperator<SimpleAttributeDefinitionBuilder>
    {
        CONNECTION_TIMEOUT("connection-timeout", ModelType.INT, new ModelNode(60000)),
        DEFAULT_REMOTE_CLUSTER("default-remote-cluster", ModelType.STRING, null){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)builder.setAllowExpression(false)).setCapabilityReference((CapabilityReferenceRecorder)new CapabilityReference((org.jboss.as.clustering.controller.Capability)Capability.CONFIGURATION, (BinaryRequirement)RemoteClusterResourceDefinition.Requirement.REMOTE_CLUSTER, WILDCARD_PATH));
            }
        }
        ,
        KEY_SIZE_ESTIMATE("key-size-estimate", ModelType.INT, new ModelNode(64)),
        MAX_RETRIES("max-retries", ModelType.INT, new ModelNode(10)),
        MODULE("module", ModelType.STRING, new ModelNode("org.jboss.as.clustering.infinispan")){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)builder.setValidator(new ModuleIdentifierValidatorBuilder().configure((AbstractAttributeDefinitionBuilder)builder).build());
            }
        }
        ,
        PROTOCOL_VERSION("protocol-version", ModelType.STRING, new ModelNode(ProtocolVersion.PROTOCOL_VERSION_29.toString())){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)builder.setValidator((ParameterValidator)new EnumValidator(ProtocolVersion.class));
            }
        }
        ,
        SOCKET_TIMEOUT("socket-timeout", ModelType.INT, new ModelNode(60000)),
        STATISTICS_ENABLED("statistics-enabled", ModelType.BOOLEAN, ModelNode.FALSE),
        TCP_NO_DELAY("tcp-no-delay", ModelType.BOOLEAN, ModelNode.TRUE),
        TCP_KEEP_ALIVE("tcp-keep-alive", ModelType.BOOLEAN, ModelNode.FALSE),
        VALUE_SIZE_ESTIMATE("value-size-estimate", ModelType.INT, new ModelNode(512));

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type, ModelNode defaultValue) {
            this.definition = this.apply((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(true)).setRequired(defaultValue == null)).setDefaultValue(defaultValue)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }

        @Override
        public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
            return builder;
        }
    }

    public static enum Capability implements CapabilityProvider
    {
        CONTAINER((UnaryRequirement)InfinispanClientRequirement.REMOTE_CONTAINER),
        CONFIGURATION((UnaryRequirement)InfinispanClientRequirement.REMOTE_CONTAINER_CONFIGURATION);

        private final org.jboss.as.clustering.controller.Capability capability;

        private Capability(UnaryRequirement requirement) {
            this.capability = new UnaryRequirementCapability(requirement);
        }

        public org.jboss.as.clustering.controller.Capability getCapability() {
            return this.capability;
        }
    }
}

