/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.docker;

import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.keycloak.models.utils.Base32;

public class DockerKeyIdentifier {
    private final String identifier;

    public DockerKeyIdentifier(Key key) throws InstantiationException {
        try {
            MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
            byte[] hashed = sha256.digest(key.getEncoded());
            byte[] hashedTruncated = this.truncateToBitLength(240, hashed);
            String base32Id = Base32.encode((byte[])hashedTruncated);
            this.identifier = this.byteStream(base32Id.getBytes()).collect(new DelimitingCollector());
        }
        catch (NoSuchAlgorithmException e) {
            throw new InstantiationException("Could not instantiate docker key identifier, no SHA-256 algorithm available.");
        }
    }

    private Stream<Byte> byteStream(byte[] bytes) {
        ArrayList<Byte> colectionedBytes = new ArrayList<Byte>();
        for (byte aByte : bytes) {
            colectionedBytes.add(aByte);
        }
        return colectionedBytes.stream();
    }

    private byte[] truncateToBitLength(int bitLength, byte[] arrayToTruncate) {
        if (bitLength % 8 != 0) {
            throw new IllegalArgumentException("Bit length for truncation of byte array given as a number not divisible by 8");
        }
        int numberOfBytes = bitLength / 8;
        return Arrays.copyOfRange(arrayToTruncate, 0, numberOfBytes);
    }

    public String toString() {
        return this.identifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DockerKeyIdentifier)) {
            return false;
        }
        DockerKeyIdentifier that = (DockerKeyIdentifier)o;
        return this.identifier != null ? this.identifier.equals(that.identifier) : that.identifier == null;
    }

    public int hashCode() {
        return this.identifier != null ? this.identifier.hashCode() : 0;
    }

    public static class DelimitingCollector
    implements Collector<Byte, StringBuilder, String> {
        @Override
        public Supplier<StringBuilder> supplier() {
            return () -> new StringBuilder();
        }

        @Override
        public BiConsumer<StringBuilder, Byte> accumulator() {
            return (stringBuilder, aByte) -> {
                if (DelimitingCollector.needsDelimiter(4, ":", stringBuilder)) {
                    stringBuilder.append(":");
                }
                stringBuilder.append(new String(new byte[]{aByte}));
            };
        }

        private static boolean needsDelimiter(int maxLength, String delimiter, StringBuilder builder) {
            int lastDelimiter = builder.lastIndexOf(delimiter);
            int charsSinceLastDelimiter = builder.length() - lastDelimiter;
            return charsSinceLastDelimiter > maxLength;
        }

        @Override
        public BinaryOperator<StringBuilder> combiner() {
            return (left, right) -> new StringBuilder(left.toString()).append(right.toString());
        }

        @Override
        public Function<StringBuilder, String> finisher() {
            return StringBuilder::toString;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Collections.emptySet();
        }
    }
}

