/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.log4j.Hierarchy;
import org.apache.log4j.JBossLevelMapping;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.RootLogger;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.Logger;

public class JBossLogManagerFacade {
    public static final String LOG4J_ROOT_NAME = "root";
    public static final String JBL_ROOT_NAME = "";
    private static final Logger.AttachmentKey<Logger> LOGGER_KEY = new Logger.AttachmentKey();
    private static final Logger.AttachmentKey<Hierarchy> HIERARCHY_KEY = new Logger.AttachmentKey();
    private static final Logger.AttachmentKey<LoggerNode> LOGGER_NODE_KEY = new Logger.AttachmentKey();
    private static final PrivilegedAction<LogContext> LOG_CONTEXT_ACTION = new PrivilegedAction<LogContext>(){

        @Override
        public LogContext run() {
            return LogContext.getLogContext();
        }
    };

    private JBossLogManagerFacade() {
    }

    static org.jboss.logmanager.Logger getJBossLogger(String name) {
        return JBossLogManagerFacade.getJBossLogger(JBossLogManagerFacade.getLogContext(), name);
    }

    static org.jboss.logmanager.Logger getJBossLogger(LogContext logContext, String name) {
        String loggerName = name == null || name.equals(LOG4J_ROOT_NAME) ? JBL_ROOT_NAME : name;
        return logContext.getLogger(loggerName);
    }

    static LoggerRepository getLoggerRepository() {
        return JBossLogManagerFacade.getLoggerRepository(null);
    }

    public static LoggerRepository getLoggerRepository(final LogContext logContext) {
        return JBossLogManagerFacade.doPrivileged(new PrivilegedAction<Hierarchy>(){

            @Override
            public Hierarchy run() {
                LogContext lc = logContext == null ? LogContext.getLogContext() : logContext;
                org.jboss.logmanager.Logger jbossRoot = JBossLogManagerFacade.getJBossLogger(lc, JBossLogManagerFacade.JBL_ROOT_NAME);
                Object hierarchy = (Hierarchy)jbossRoot.getAttachment(HIERARCHY_KEY);
                if (hierarchy == null) {
                    Object appearing;
                    Object root = (Logger)jbossRoot.getAttachment(LOGGER_KEY);
                    if (root == null) {
                        root = new RootLogger(JBossLevelMapping.getPriorityFor(jbossRoot.getLevel()));
                        appearing = (Logger)jbossRoot.attachIfAbsent(LOGGER_KEY, root);
                        if (appearing != null) {
                            root = appearing;
                        }
                    }
                    hierarchy = new Hierarchy((Logger)root);
                    appearing = (Hierarchy)jbossRoot.attachIfAbsent(HIERARCHY_KEY, hierarchy);
                    if (appearing != null) {
                        hierarchy = appearing;
                    }
                }
                return hierarchy;
            }
        });
    }

    static Logger exists(String name) {
        org.jboss.logmanager.Logger logger = JBossLogManagerFacade.getLogContext().getLoggerIfExists(name);
        return logger == null ? null : JBossLogManagerFacade.getLogger(logger);
    }

    static Logger getLogger(org.jboss.logmanager.Logger lmLogger) {
        return JBossLogManagerFacade.getAttachment(lmLogger, LOGGER_KEY);
    }

    static Logger getOrCreateLogger(LoggerRepository repository, String name, LoggerFactory factory) {
        final org.jboss.logmanager.Logger lmLogger = JBossLogManagerFacade.getJBossLogger(name);
        Logger logger = JBossLogManagerFacade.getLogger(lmLogger);
        if (logger == null) {
            LoggerNode loggerNode;
            logger = factory.makeNewLoggerInstance(name);
            Logger currentLogger = JBossLogManagerFacade.attachIfAbsent(lmLogger, LOGGER_KEY, logger);
            if (currentLogger != null) {
                logger = currentLogger;
            }
            if ((loggerNode = System.getSecurityManager() == null ? (LoggerNode)lmLogger.detach(LOGGER_NODE_KEY) : AccessController.doPrivileged(new PrivilegedAction<LoggerNode>(){

                @Override
                public LoggerNode run() {
                    return (LoggerNode)lmLogger.detach(LOGGER_NODE_KEY);
                }
            })) != null) {
                JBossLogManagerFacade.updateChildren(loggerNode, logger);
            }
            JBossLogManagerFacade.updateParents(repository, logger, lmLogger);
        }
        return logger;
    }

    static Collection<Logger> getLoggers() {
        LogContext logContext = JBossLogManagerFacade.getLogContext();
        List<String> loggerNames = logContext.getLoggingMXBean().getLoggerNames();
        ArrayList<Logger> currentLoggers = new ArrayList<Logger>(loggerNames.size());
        for (String name : loggerNames) {
            Logger logger;
            org.jboss.logmanager.Logger lmLogger = logContext.getLoggerIfExists(name);
            if (lmLogger == null || (logger = JBossLogManagerFacade.getLogger(lmLogger)) == null) continue;
            currentLoggers.add(logger);
        }
        return currentLoggers;
    }

    private static void updateParents(LoggerRepository repository, Logger cat, org.jboss.logmanager.Logger parentLogger) {
        LogContext logContext = parentLogger.getLogContext();
        String name = cat.getName();
        int length = name.length();
        boolean addRootAsParent = true;
        int i = name.lastIndexOf(46, length - 1);
        while (i >= 0) {
            String loggerName = name.substring(0, i);
            org.jboss.logmanager.Logger lmLogger = logContext.getLoggerIfExists(loggerName);
            if (lmLogger != null) {
                cat.parent = JBossLogManagerFacade.getLogger(lmLogger);
                if (cat.parent != null) {
                    addRootAsParent = false;
                    break;
                }
                LoggerNode loggerNode = (LoggerNode)lmLogger.getAttachment(LOGGER_NODE_KEY);
                if (loggerNode == null) {
                    LoggerNode appearing = JBossLogManagerFacade.attachIfAbsent(lmLogger, LOGGER_NODE_KEY, new LoggerNode(cat));
                    if (appearing != null) {
                        appearing.add(cat);
                    }
                } else {
                    loggerNode.add(cat);
                }
            }
            i = name.lastIndexOf(46, i - 1);
        }
        if (addRootAsParent) {
            cat.parent = repository.getRootLogger();
        }
    }

    private static void updateChildren(LoggerNode loggerNode, Logger logger) {
        for (Logger l : loggerNode) {
            if (l.parent.getName().startsWith(logger.getName())) continue;
            logger.parent = l.parent;
            l.parent = logger;
        }
    }

    private static LogContext getLogContext() {
        return JBossLogManagerFacade.doPrivileged(LOG_CONTEXT_ACTION);
    }

    private static <T> T getAttachment(final org.jboss.logmanager.Logger logger, final Logger.AttachmentKey<T> key) {
        return JBossLogManagerFacade.doPrivileged(new PrivilegedAction<T>(){

            @Override
            public T run() {
                return logger.getAttachment(key);
            }
        });
    }

    private static <T> T attachIfAbsent(final org.jboss.logmanager.Logger logger, final Logger.AttachmentKey<T> key, final T value) {
        return JBossLogManagerFacade.doPrivileged(new PrivilegedAction<T>(){

            @Override
            public T run() {
                return logger.attachIfAbsent(key, value);
            }
        });
    }

    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        if (System.getSecurityManager() == null) {
            return action.run();
        }
        return AccessController.doPrivileged(action);
    }

    private static class LoggerComparator
    implements Comparator<Logger> {
        static final LoggerComparator INSTANCE = new LoggerComparator();

        private LoggerComparator() {
        }

        @Override
        public int compare(Logger o1, Logger o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    private static class LoggerNode
    implements Iterable<Logger> {
        private final Set<Logger> loggers = new ConcurrentSkipListSet<Logger>(LoggerComparator.INSTANCE);

        public LoggerNode(Logger logger) {
            this.loggers.add(logger);
        }

        public void add(Logger logger) {
            this.loggers.add(logger);
        }

        @Override
        public Iterator<Logger> iterator() {
            return this.loggers.iterator();
        }
    }
}

