/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.authorization.entities;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.Scope;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.models.cache.infinispan.DefaultLazyLoader;
import org.keycloak.models.cache.infinispan.LazyLoader;
import org.keycloak.models.cache.infinispan.authorization.entities.InResourceServer;
import org.keycloak.models.cache.infinispan.entities.AbstractRevisioned;

public class CachedResource
extends AbstractRevisioned
implements InResourceServer {
    private final String resourceServerId;
    private final String iconUri;
    private final String owner;
    private final String type;
    private final String name;
    private final String displayName;
    private final boolean ownerManagedAccess;
    private LazyLoader<Resource, Set<String>> scopesIds;
    private LazyLoader<Resource, Set<String>> uris;
    private LazyLoader<Resource, MultivaluedHashMap<String, String>> attributes;

    public CachedResource(Long revision, Resource resource) {
        super(revision, resource.getId());
        MultivaluedHashMap data;
        this.name = resource.getName();
        this.displayName = resource.getDisplayName();
        this.type = resource.getType();
        this.owner = resource.getOwner();
        this.iconUri = resource.getIconUri();
        this.resourceServerId = resource.getResourceServer().getId();
        this.ownerManagedAccess = resource.isOwnerManagedAccess();
        if (resource.isFetched("uris")) {
            data = new HashSet(resource.getUris());
            this.uris = source -> data;
        } else {
            this.uris = new DefaultLazyLoader<Resource, Set>(source -> new HashSet(source.getUris()), Collections::emptySet);
        }
        if (resource.isFetched("scopes")) {
            data = resource.getScopes().stream().map(Scope::getId).collect(Collectors.toSet());
            this.scopesIds = source -> data;
        } else {
            this.scopesIds = new DefaultLazyLoader<Resource, Set>(source -> source.getScopes().stream().map(Scope::getId).collect(Collectors.toSet()), Collections::emptySet);
        }
        if (resource.isFetched("attributes")) {
            data = new MultivaluedHashMap(resource.getAttributes());
            this.attributes = source -> data;
        } else {
            this.attributes = new DefaultLazyLoader<Resource, MultivaluedHashMap>(source -> new MultivaluedHashMap(source.getAttributes()), MultivaluedHashMap::new);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Set<String> getUris(Supplier<Resource> source) {
        return this.uris.get(source);
    }

    public String getType() {
        return this.type;
    }

    public String getIconUri() {
        return this.iconUri;
    }

    public String getOwner() {
        return this.owner;
    }

    public boolean isOwnerManagedAccess() {
        return this.ownerManagedAccess;
    }

    @Override
    public String getResourceServerId() {
        return this.resourceServerId;
    }

    public Set<String> getScopesIds(Supplier<Resource> source) {
        return this.scopesIds.get(source);
    }

    public Map<String, List<String>> getAttributes(Supplier<Resource> source) {
        return (Map)this.attributes.get(source);
    }
}

