/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.config.http;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.picketlink.config.http.AbstractPathConfigurationChildBuilder;
import org.picketlink.config.http.AuthorizationConfiguration;
import org.picketlink.config.http.PathConfiguration;
import org.picketlink.config.http.PathConfigurationBuilder;
import org.picketlink.http.authorization.PathAuthorizer;

public class AuthorizationConfigurationBuilder
extends AbstractPathConfigurationChildBuilder {
    private String[] rolesAllowed;
    private String[] groupsAllowed;
    private String[] realmsAllowed;
    private String[] elExpresion;
    private List<Class<? extends PathAuthorizer>> authorizers = new ArrayList<Class<? extends PathAuthorizer>>();

    AuthorizationConfigurationBuilder(PathConfigurationBuilder parentBuilder) {
        super(parentBuilder);
    }

    public AuthorizationConfigurationBuilder role(String ... roleNames) {
        this.rolesAllowed = roleNames;
        return this;
    }

    public AuthorizationConfigurationBuilder group(String ... groupNames) {
        this.groupsAllowed = groupNames;
        return this;
    }

    public AuthorizationConfigurationBuilder realm(String ... realmNames) {
        this.realmsAllowed = realmNames;
        return this;
    }

    public AuthorizationConfigurationBuilder expression(String ... expression) {
        this.elExpresion = expression;
        return this;
    }

    public AuthorizationConfigurationBuilder authorizer(Class<? extends PathAuthorizer> ... pathAuthorizer) {
        this.authorizers.addAll(Arrays.asList(pathAuthorizer));
        return this;
    }

    AuthorizationConfiguration create(PathConfiguration pathConfiguration) {
        return new AuthorizationConfiguration(pathConfiguration, this.rolesAllowed, this.groupsAllowed, this.realmsAllowed, this.elExpresion, this.authorizers);
    }
}

