/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.annotate.JsonTypeInfo;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.jsontype.TypeIdResolver;

public abstract class TypeDeserializer {
    protected static final Set<String> ALLOW_DESER_PACKAGES;

    public abstract JsonTypeInfo.As getTypeInclusion();

    public abstract String getPropertyName();

    public abstract TypeIdResolver getTypeIdResolver();

    public abstract Class<?> getDefaultImpl();

    public abstract Object deserializeTypedFromObject(JsonParser var1, DeserializationContext var2) throws IOException, JsonProcessingException;

    public abstract Object deserializeTypedFromArray(JsonParser var1, DeserializationContext var2) throws IOException, JsonProcessingException;

    public abstract Object deserializeTypedFromScalar(JsonParser var1, DeserializationContext var2) throws IOException, JsonProcessingException;

    public abstract Object deserializeTypedFromAny(JsonParser var1, DeserializationContext var2) throws IOException, JsonProcessingException;

    protected static void checkLegalTypes(JsonParser parser, String typeId) throws JsonMappingException {
        if (typeId == null || "".equals(typeId)) {
            return;
        }
        while (typeId.charAt(0) == '[') {
            if ((typeId = typeId.substring(1)).isEmpty() || typeId.charAt(0) != 'L') continue;
            typeId = typeId.substring(1);
        }
        if (typeId.length() == 1) {
            return;
        }
        Iterator<String> iter = ALLOW_DESER_PACKAGES.iterator();
        boolean pass = false;
        while (iter.hasNext()) {
            if (!typeId.startsWith(iter.next())) continue;
            pass = true;
            break;
        }
        if (!pass) {
            throw new JsonMappingException(String.format("Illegal type (%s) to deserialize: prevented for security reasons", typeId));
        }
    }

    static {
        String strlist = System.getProperty("jackson.deserialization.whitelist.packages");
        HashSet<Object> s = new HashSet();
        if (strlist != null) {
            s = new HashSet<String>(Arrays.asList(strlist.split(",")));
        }
        ALLOW_DESER_PACKAGES = Collections.unmodifiableSet(s);
    }
}

