/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.device;

import java.io.IOException;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Base64;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserSessionModel;
import org.keycloak.representations.account.DeviceRepresentation;
import org.keycloak.util.JsonSerialization;
import ua_parser.Client;
import ua_parser.Parser;

public class DeviceActivityManager {
    private static final String DEVICE_NOTE = "KC_DEVICE_NOTE";
    private static final Logger logger = Logger.getLogger(DeviceActivityManager.class);
    private static final int USER_AGENT_MAX_LENGTH = 512;
    private static final Parser UA_PARSER;

    public static DeviceRepresentation getCurrentDevice(UserSessionModel userSession) {
        String deviceInfo = userSession.getNote(DEVICE_NOTE);
        if (deviceInfo == null) {
            return null;
        }
        try {
            return (DeviceRepresentation)JsonSerialization.readValue((byte[])Base64.decode((String)deviceInfo), DeviceRepresentation.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void attachDevice(UserSessionModel userSession, KeycloakSession session) {
        DeviceRepresentation current = DeviceActivityManager.getDeviceFromUserAgent(session);
        if (current != null) {
            try {
                userSession.setNote(DEVICE_NOTE, Base64.encodeBytes((byte[])JsonSerialization.writeValueAsBytes((Object)current)));
            }
            catch (IOException cause) {
                throw new RuntimeException(cause);
            }
        }
    }

    private static DeviceRepresentation getDeviceFromUserAgent(KeycloakSession session) {
        DeviceRepresentation current;
        KeycloakContext context = session.getContext();
        String userAgent = context.getRequestHeaders().getHeaderString("User-Agent");
        if (userAgent == null) {
            return null;
        }
        if (userAgent.length() > 512) {
            logger.warn((Object)"Ignoring User-Agent header. Length is above the permitted: 512");
            return null;
        }
        try {
            Client client = UA_PARSER.parse(userAgent);
            current = new DeviceRepresentation();
            current.setDevice(client.device.family);
            String browserVersion = client.userAgent.major;
            if (client.userAgent.minor != null) {
                browserVersion = browserVersion + "." + client.userAgent.minor;
            }
            if (client.userAgent.patch != null) {
                browserVersion = browserVersion + "." + client.userAgent.patch;
            }
            if (browserVersion == null) {
                browserVersion = "Unknown";
            }
            current.setBrowser(client.userAgent.family, browserVersion);
            current.setOs(client.os.family);
            String osVersion = client.os.major;
            if (client.os.minor != null) {
                osVersion = osVersion + "." + client.os.minor;
            }
            if (client.os.patch != null) {
                osVersion = osVersion + "." + client.os.patch;
            }
            if (client.os.patchMinor != null) {
                osVersion = osVersion + "." + client.os.patchMinor;
            }
            current.setOsVersion(osVersion);
            current.setIpAddress(context.getConnection().getRemoteAddr());
            current.setMobile(userAgent.toLowerCase().contains("mobile"));
        }
        catch (Exception cause) {
            logger.error((Object)"Failed to create device info from user agent header", (Throwable)cause);
            return null;
        }
        return current;
    }

    static {
        try {
            UA_PARSER = new Parser();
        }
        catch (IOException cause) {
            throw new RuntimeException("Failed to create user agent parser", cause);
        }
    }
}

