/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.service;

import java.util.concurrent.ConcurrentMap;
import javax.security.auth.login.Configuration;
import org.jboss.as.security.SecurityExtension;
import org.jboss.as.security.logging.SecurityLogger;
import org.jboss.as.security.plugins.AuthenticationCacheFactory;
import org.jboss.as.security.plugins.DefaultAuthenticationCacheFactory;
import org.jboss.as.security.plugins.JNDIBasedSecurityManagement;
import org.jboss.as.security.plugins.SecurityDomainContext;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.security.ISecurityManagement;
import org.jboss.security.JSSESecurityDomain;
import org.jboss.security.config.ApplicationPolicy;
import org.jboss.security.config.ApplicationPolicyRegistration;

public class SecurityDomainService
implements Service<SecurityDomainContext> {
    public static final ServiceName SERVICE_NAME = SecurityExtension.JBOSS_SECURITY.append(new String[]{"security-domain"});
    private final InjectedValue<ISecurityManagement> securityManagementValue = new InjectedValue();
    private final InjectedValue<Configuration> configurationValue = new InjectedValue();
    private final InjectedValue<ConcurrentMap> cacheValue = new InjectedValue();
    private final String name;
    private final ApplicationPolicy applicationPolicy;
    private final JSSESecurityDomain jsseSecurityDomain;
    private volatile SecurityDomainContext securityDomainContext;
    private final String cacheType;

    public SecurityDomainService(String name, ApplicationPolicy applicationPolicy, JSSESecurityDomain jsseSecurityDomain, String cacheType) {
        this.name = name;
        this.applicationPolicy = applicationPolicy;
        this.jsseSecurityDomain = jsseSecurityDomain;
        this.cacheType = cacheType;
    }

    public void start(StartContext context) throws StartException {
        SecurityDomainContext sdc;
        SecurityLogger.ROOT_LOGGER.debugf("Starting SecurityDomainService(%s)", this.name);
        if (this.applicationPolicy != null) {
            ApplicationPolicyRegistration applicationPolicyRegistration = (ApplicationPolicyRegistration)this.configurationValue.getValue();
            applicationPolicyRegistration.addApplicationPolicy(this.applicationPolicy.getName(), this.applicationPolicy);
        }
        JNDIBasedSecurityManagement securityManagement = (JNDIBasedSecurityManagement)this.securityManagementValue.getValue();
        AuthenticationCacheFactory cacheFactory = null;
        if ("infinispan".equals(this.cacheType)) {
            cacheFactory = () -> (ConcurrentMap)this.cacheValue.getValue();
        } else if ("default".equals(this.cacheType)) {
            cacheFactory = new DefaultAuthenticationCacheFactory();
        }
        try {
            sdc = securityManagement.createSecurityDomainContext(this.name, cacheFactory, this.jsseSecurityDomain);
        }
        catch (Exception e) {
            throw SecurityLogger.ROOT_LOGGER.unableToStartException("SecurityDomainService", e);
        }
        if (this.jsseSecurityDomain != null) {
            try {
                this.jsseSecurityDomain.reloadKeyAndTrustStore();
            }
            catch (Exception e) {
                throw SecurityLogger.ROOT_LOGGER.unableToStartException("SecurityDomainService", e);
            }
        }
        securityManagement.getSecurityManagerMap().put(this.name, sdc);
        this.securityDomainContext = sdc;
    }

    public void stop(StopContext context) {
        SecurityLogger.ROOT_LOGGER.debugf("Stopping security domain service %s", this.name);
        JNDIBasedSecurityManagement securityManagement = (JNDIBasedSecurityManagement)this.securityManagementValue.getValue();
        securityManagement.removeSecurityDomain(this.name);
        ApplicationPolicyRegistration applicationPolicyRegistration = (ApplicationPolicyRegistration)this.configurationValue.getValue();
        applicationPolicyRegistration.removeApplicationPolicy(this.name);
    }

    public SecurityDomainContext getValue() throws IllegalStateException, IllegalArgumentException {
        return this.securityDomainContext;
    }

    public Injector<ISecurityManagement> getSecurityManagementInjector() {
        return this.securityManagementValue;
    }

    public Injector<Configuration> getConfigurationInjector() {
        return this.configurationValue;
    }

    public Injector<ConcurrentMap> getCacheInjector() {
        return this.cacheValue;
    }
}

