/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.security.spec.AlgorithmParameterSpec;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import org.wildfly.common.Assert;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.credential.AlgorithmCredential;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.util.EnumerationIterator;

public abstract class IdentityCredentials
implements Iterable<Credential>,
CredentialSource {
    public static final IdentityCredentials NONE = new IdentityCredentials(){

        @Override
        public boolean contains(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) {
            Assert.checkNotNullParam((String)"credentialType", credentialType);
            return false;
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) {
            Assert.checkNotNullParam((String)"credentialType", credentialType);
            return null;
        }

        @Override
        public IdentityCredentials with(IdentityCredentials other) {
            Assert.checkNotNullParam((String)"other", (Object)other);
            return other;
        }

        @Override
        public IdentityCredentials withCredential(Credential credential) {
            Assert.checkNotNullParam((String)"credential", (Object)credential);
            return new One(credential);
        }

        @Override
        public CredentialSource with(CredentialSource other) {
            Assert.checkNotNullParam((String)"other", (Object)other);
            return other;
        }

        @Override
        public Iterator<Credential> iterator() {
            return Collections.emptyIterator();
        }

        @Override
        public <C extends Credential, R> R applyToCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec, Function<C, R> function) {
            Assert.checkNotNullParam((String)"credentialType", credentialType);
            return null;
        }

        @Override
        public IdentityCredentials withoutMatching(Credential credential) {
            Assert.checkNotNullParam((String)"credential", (Object)credential);
            return this;
        }

        @Override
        public IdentityCredentials without(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) {
            Assert.checkNotNullParam((String)"credentialType", credentialType);
            return this;
        }

        @Override
        public IdentityCredentials without(Predicate<? super Credential> predicate) {
            Assert.checkNotNullParam((String)"predicate", predicate);
            return this;
        }

        @Override
        public Spliterator<Credential> spliterator() {
            return Spliterators.emptySpliterator();
        }

        @Override
        public void forEach(Consumer<? super Credential> action) {
            Assert.checkNotNullParam((String)"action", action);
        }

        @Override
        public int size() {
            return 0;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            return o == this;
        }
    };

    IdentityCredentials() {
    }

    public final boolean contains(Class<? extends Credential> credentialType) {
        return this.contains(credentialType, null);
    }

    @Override
    public final SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) {
        return this.contains(credentialType, algorithmName, parameterSpec) ? SupportLevel.SUPPORTED : SupportLevel.UNSUPPORTED;
    }

    @Override
    public final SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) {
        return this.contains(credentialType, algorithmName) ? SupportLevel.SUPPORTED : SupportLevel.UNSUPPORTED;
    }

    @Override
    public final SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType) {
        return this.contains(credentialType) ? SupportLevel.SUPPORTED : SupportLevel.UNSUPPORTED;
    }

    public abstract boolean contains(Class<? extends Credential> var1, String var2, AlgorithmParameterSpec var3);

    public final boolean contains(Class<? extends Credential> credentialType, String algorithmName) {
        Assert.checkNotNullParam((String)"credentialType", credentialType);
        return this.contains(credentialType, algorithmName, null);
    }

    public final boolean containsMatching(Credential credential) {
        Assert.checkNotNullParam((String)"credential", (Object)credential);
        if (credential instanceof AlgorithmCredential) {
            AlgorithmCredential algorithmCredential = (AlgorithmCredential)credential;
            return this.contains(credential.getClass(), algorithmCredential.getAlgorithm(), algorithmCredential.getParameters());
        }
        return this.contains(credential.getClass(), null, null);
    }

    @Override
    public final <C extends Credential> C getCredential(Class<C> credentialType) {
        return this.getCredential(credentialType, null, null);
    }

    @Override
    public final <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName) {
        return this.getCredential(credentialType, algorithmName, null);
    }

    @Override
    public abstract <C extends Credential> C getCredential(Class<C> var1, String var2, AlgorithmParameterSpec var3);

    @Override
    public final <C extends Credential, R> R applyToCredential(Class<C> credentialType, Function<C, R> function) {
        C credential = this.getCredential(credentialType);
        return (R)(credential == null ? null : credential.castAndApply(credentialType, function));
    }

    @Override
    public final <C extends Credential, R> R applyToCredential(Class<C> credentialType, String algorithmName, Function<C, R> function) {
        C credential = this.getCredential(credentialType, algorithmName);
        return (R)(credential == null ? null : credential.castAndApply(credentialType, algorithmName, function));
    }

    @Override
    public <C extends Credential, R> R applyToCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec, Function<C, R> function) {
        C credential = this.getCredential(credentialType, algorithmName, parameterSpec);
        return (R)(credential == null ? null : credential.castAndApply(credentialType, algorithmName, parameterSpec, function));
    }

    public abstract IdentityCredentials withCredential(Credential var1);

    public abstract IdentityCredentials with(IdentityCredentials var1);

    public IdentityCredentials withoutMatching(Credential credential) {
        Assert.checkNotNullParam((String)"credential", (Object)credential);
        return this.without(arg_0 -> ((Credential)credential).matches(arg_0));
    }

    @Override
    public final IdentityCredentials without(Class<? extends Credential> credentialType) {
        Assert.checkNotNullParam((String)"credentialType", credentialType);
        return this.without(credentialType::isInstance);
    }

    @Override
    public final IdentityCredentials without(Class<? extends Credential> credentialType, String algorithmName) {
        Assert.checkNotNullParam((String)"credentialType", credentialType);
        return this.without((Class)credentialType, algorithmName, (AlgorithmParameterSpec)null);
    }

    @Override
    public IdentityCredentials without(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) {
        Assert.checkNotNullParam((String)"credentialType", credentialType);
        return this.without((? super Credential c) -> c.matches(credentialType, algorithmName, parameterSpec));
    }

    public abstract IdentityCredentials without(Predicate<? super Credential> var1);

    public final <C extends Credential> IdentityCredentials without(Class<C> credentialType, Predicate<? super C> predicate) {
        return this.without((? super Credential c) -> credentialType.isInstance(c) && predicate.test((Object)credentialType.cast(c)));
    }

    @Override
    public Spliterator<Credential> spliterator() {
        return Spliterators.spliterator(this.iterator(), (long)this.size(), 1361);
    }

    public boolean canVerify(Class<? extends Evidence> evidenceClass, String algorithmName) {
        return StreamSupport.stream(this.spliterator(), false).filter(credential -> credential.canVerify(evidenceClass, algorithmName)).count() != 0L;
    }

    public boolean canVerify(Evidence evidence) {
        return StreamSupport.stream(this.spliterator(), false).filter(credential -> credential.canVerify(evidence)).count() != 0L;
    }

    public boolean verify(Evidence evidence) {
        return StreamSupport.stream(this.spliterator(), false).filter(credential -> credential.canVerify(evidence)).filter(credential -> credential.verify(evidence)).count() != 0L;
    }

    public abstract int size();

    static int typeHash(Credential credential) {
        int ch = credential.getClass().hashCode();
        if (credential instanceof AlgorithmCredential) {
            AlgorithmCredential algorithmCredential = (AlgorithmCredential)credential;
            return HashMath.multiHashOrdered((int)HashMath.multiHashOrdered((int)ch, (int)42979, (int)Objects.hashCode(algorithmCredential.getAlgorithm())), (int)62861, (int)Objects.hashCode(algorithmCredential.getParameters()));
        }
        return ch;
    }

    static final class Key {
        private final Class<? extends Credential> clazz;
        private final String algorithm;
        private final AlgorithmParameterSpec parameterSpec;
        private final int hashCode;

        Key(Class<? extends Credential> clazz, String algorithm, AlgorithmParameterSpec parameterSpec) {
            this.clazz = clazz;
            this.algorithm = algorithm;
            this.parameterSpec = parameterSpec;
            this.hashCode = HashMath.multiHashOrdered((int)HashMath.multiHashOrdered((int)clazz.hashCode(), (int)42979, (int)Objects.hashCode(algorithm)), (int)62861, (int)Objects.hashCode(parameterSpec));
        }

        static Key of(Credential c) {
            if (c instanceof AlgorithmCredential) {
                AlgorithmCredential ac = (AlgorithmCredential)c;
                return new Key(ac.getClass(), ac.getAlgorithm(), ac.getParameters());
            }
            return new Key(c.getClass(), null, null);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            return obj instanceof Key && this.equals((Key)obj);
        }

        private boolean equals(Key key) {
            return this.clazz == key.clazz && Objects.equals(this.algorithm, key.algorithm) && Objects.equals(this.parameterSpec, key.parameterSpec);
        }

        Class<? extends Credential> getClazz() {
            return this.clazz;
        }

        String getAlgorithm() {
            return this.algorithm;
        }

        AlgorithmParameterSpec getParameterSpec() {
            return this.parameterSpec;
        }
    }

    static class Many
    extends IdentityCredentials {
        private final LinkedHashMap<Key, Credential> map;
        private final int hashCode;

        Many(Credential c1, Many subsequent) {
            LinkedHashMap<Key, Credential> map = new LinkedHashMap<Key, Credential>(subsequent.map.size() + 1);
            map.put(Key.of(c1), c1);
            map.putAll(subsequent.map);
            this.map = map;
            int hc = 0;
            for (Credential credential : map.values()) {
                hc ^= Many.typeHash(credential);
            }
            this.hashCode = hc;
            assert (this.size() > 2);
        }

        Many(Credential c1, Credential c2, Many subsequent) {
            LinkedHashMap<Key, Credential> map = new LinkedHashMap<Key, Credential>(subsequent.map.size() + 2);
            map.put(Key.of(c1), c1);
            map.put(Key.of(c2), c2);
            map.putAll(subsequent.map);
            this.map = map;
            int hc = 0;
            for (Credential credential : map.values()) {
                hc ^= Many.typeHash(credential);
            }
            this.hashCode = hc;
            assert (this.size() > 2);
        }

        Many(LinkedHashMap<Key, Credential> map) {
            this.map = map;
            int hc = 0;
            for (Credential credential : map.values()) {
                hc ^= Many.typeHash(credential);
            }
            this.hashCode = hc;
            assert (this.size() > 2);
        }

        Many(Credential credential1, Credential credential2, Credential credential3) {
            LinkedHashMap<Key, Credential> map = new LinkedHashMap<Key, Credential>(3);
            map.put(Key.of(credential1), credential1);
            map.put(Key.of(credential2), credential2);
            map.put(Key.of(credential3), credential3);
            this.map = map;
            int hc = 0;
            for (Credential credential : map.values()) {
                hc ^= Many.typeHash(credential);
            }
            this.hashCode = hc;
            assert (this.size() > 2);
        }

        @Override
        public boolean contains(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) {
            return this.map.containsKey(new Key(credentialType, algorithmName, parameterSpec));
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) {
            return (C)((Credential)credentialType.cast(this.map.get(new Key(credentialType, algorithmName, parameterSpec)).clone()));
        }

        @Override
        public IdentityCredentials withoutMatching(Credential credential) {
            Key key = Key.of(credential);
            if (this.map.containsKey(key)) {
                LinkedHashMap<Key, Credential> clone = new LinkedHashMap<Key, Credential>(this.map);
                clone.remove(key);
                if (clone.size() == 2) {
                    Iterator<Credential> iterator = clone.values().iterator();
                    return new Two(iterator.next(), iterator.next());
                }
                return new Many(clone);
            }
            return this;
        }

        @Override
        public void forEach(Consumer<? super Credential> action) {
            this.map.values().forEach(action);
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public IdentityCredentials withCredential(Credential credential) {
            LinkedHashMap<Key, Credential> clone = new LinkedHashMap<Key, Credential>(this.map);
            Key key = Key.of(credential);
            clone.remove(key);
            clone.put(key, credential);
            return new Many(clone);
        }

        @Override
        public IdentityCredentials with(IdentityCredentials other) {
            LinkedHashMap<Key, Credential> clone = new LinkedHashMap<Key, Credential>(this.map);
            for (Credential credential : other) {
                Key key = Key.of(credential);
                clone.remove(key);
                clone.put(key, credential);
            }
            return new Many(clone);
        }

        @Override
        public CredentialSource with(CredentialSource other) {
            return other instanceof IdentityCredentials ? this.with((IdentityCredentials)other) : super.with(other);
        }

        @Override
        public Iterator<Credential> iterator() {
            return Collections.unmodifiableCollection(this.map.values()).iterator();
        }

        @Override
        public <C extends Credential, R> R applyToCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec, Function<C, R> function) {
            Key key = new Key(credentialType, algorithmName, parameterSpec);
            Credential credential = this.map.get(key);
            if (credential != null) {
                return function.apply((Credential)credentialType.cast(credential));
            }
            return null;
        }

        @Override
        public IdentityCredentials without(Predicate<? super Credential> predicate) {
            LinkedHashMap<Key, Credential> clone = new LinkedHashMap<Key, Credential>(this.map);
            Collection<Credential> values = clone.values();
            values.removeIf(predicate);
            Iterator<Credential> iterator = values.iterator();
            if (iterator.hasNext()) {
                Credential c1 = iterator.next();
                if (iterator.hasNext()) {
                    Credential c2 = iterator.next();
                    if (iterator.hasNext()) {
                        return new Many(clone);
                    }
                    return new Two(c1, c2);
                }
                return new One(c1);
            }
            return NONE;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Many)) {
                return false;
            }
            Many many = (Many)obj;
            if (this.hashCode != many.hashCode) {
                return false;
            }
            if (this.map.size() != many.map.size()) {
                return false;
            }
            for (Map.Entry<Key, Credential> entry : this.map.entrySet()) {
                if (Objects.equals(many.map.get(entry.getKey()), entry.getValue())) continue;
                return false;
            }
            return true;
        }
    }

    static class Two
    extends IdentityCredentials {
        private final Credential credential1;
        private final Credential credential2;

        Two(Credential credential1, Credential credential2) {
            this.credential1 = credential1;
            this.credential2 = credential2;
        }

        @Override
        public boolean contains(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) {
            Assert.checkNotNullParam((String)"credentialType", credentialType);
            return this.credential1.matches(credentialType, algorithmName, parameterSpec) || this.credential2.matches(credentialType, algorithmName, parameterSpec);
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) {
            Assert.checkNotNullParam((String)"credentialType", credentialType);
            return (C)(this.credential1.matches(credentialType, algorithmName, parameterSpec) ? (Credential)credentialType.cast(this.credential1.clone()) : (this.credential2.matches(credentialType, algorithmName, parameterSpec) ? (Credential)credentialType.cast(this.credential2.clone()) : null));
        }

        @Override
        public IdentityCredentials withCredential(Credential credential) {
            Assert.checkNotNullParam((String)"credential", (Object)credential);
            if (credential.matches(this.credential1)) {
                return new Two(this.credential2, credential);
            }
            if (credential.matches(this.credential2)) {
                return new Two(this.credential1, credential);
            }
            return new Many(this.credential1, this.credential2, credential);
        }

        @Override
        public IdentityCredentials with(IdentityCredentials other) {
            Assert.checkNotNullParam((String)"other", (Object)other);
            if (other == NONE) {
                return this;
            }
            if (other instanceof One) {
                return this.withCredential(((One)other).credential);
            }
            if (other instanceof Two) {
                Two otherTwo = (Two)other;
                return this.withCredential(otherTwo.credential1).withCredential(otherTwo.credential2);
            }
            if (other instanceof Many) {
                Many otherMany = (Many)other;
                if (otherMany.containsMatching(this.credential1)) {
                    if (otherMany.containsMatching(this.credential2)) {
                        return otherMany;
                    }
                    return new Many(this.credential2, otherMany);
                }
                if (otherMany.containsMatching(this.credential2)) {
                    return new Many(this.credential1, otherMany);
                }
                return new Many(this.credential1, this.credential2, otherMany);
            }
            throw Assert.unreachableCode();
        }

        @Override
        public CredentialSource with(CredentialSource other) {
            Assert.checkNotNullParam((String)"other", (Object)other);
            if (other instanceof IdentityCredentials) {
                return this.with((IdentityCredentials)other);
            }
            return super.with(other);
        }

        @Override
        public Iterator<Credential> iterator() {
            return EnumerationIterator.over((Object)this.credential1);
        }

        @Override
        public <C extends Credential, R> R applyToCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec, Function<C, R> function) {
            Assert.checkNotNullParam((String)"credentialType", credentialType);
            return (R)this.credential1.castAndApply(credentialType, algorithmName, parameterSpec, function);
        }

        @Override
        public IdentityCredentials withoutMatching(Credential credential) {
            Assert.checkNotNullParam((String)"credential", (Object)credential);
            return this.credential1.matches(credential) ? NONE : this;
        }

        @Override
        public IdentityCredentials without(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) {
            Assert.checkNotNullParam((String)"credentialType", credentialType);
            return this.credential1.matches(credentialType, algorithmName, parameterSpec) ? NONE : this;
        }

        @Override
        public IdentityCredentials without(Predicate<? super Credential> predicate) {
            Assert.checkNotNullParam((String)"predicate", predicate);
            return predicate.test((Credential)this.credential1) ? (predicate.test((Credential)this.credential2) ? NONE : new One(this.credential2)) : (predicate.test((Credential)this.credential2) ? new One(this.credential1) : this);
        }

        @Override
        public void forEach(Consumer<? super Credential> action) {
            Assert.checkNotNullParam((String)"action", action);
            action.accept((Credential)this.credential1);
            action.accept((Credential)this.credential2);
        }

        @Override
        public int size() {
            return 2;
        }

        public int hashCode() {
            return Two.typeHash(this.credential1) ^ Two.typeHash(this.credential2);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Two)) {
                return false;
            }
            Two two = (Two)obj;
            return this.credential1.equals(two.credential1) && this.credential2.equals(two.credential2) || this.credential1.equals(two.credential2) && this.credential2.equals(two.credential1);
        }
    }

    static class One
    extends IdentityCredentials {
        private final Credential credential;

        One(Credential credential) {
            this.credential = credential;
        }

        @Override
        public boolean contains(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) {
            Assert.checkNotNullParam((String)"credentialType", credentialType);
            return this.credential.matches(credentialType, algorithmName, parameterSpec);
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) {
            Assert.checkNotNullParam((String)"credentialType", credentialType);
            return (C)(this.credential.matches(credentialType, algorithmName, parameterSpec) ? (Credential)credentialType.cast(this.credential.clone()) : null);
        }

        @Override
        public IdentityCredentials withCredential(Credential credential) {
            Assert.checkNotNullParam((String)"credential", (Object)credential);
            if (this.credential.matches(credential)) {
                return new One(credential);
            }
            return new Two(this.credential, credential);
        }

        @Override
        public IdentityCredentials with(IdentityCredentials other) {
            Assert.checkNotNullParam((String)"other", (Object)other);
            if (other == NONE) {
                return this;
            }
            if (other instanceof One) {
                return this.withCredential(((One)other).credential);
            }
            return other.with(this);
        }

        @Override
        public CredentialSource with(CredentialSource other) {
            Assert.checkNotNullParam((String)"other", (Object)other);
            if (other instanceof IdentityCredentials) {
                return this.with((IdentityCredentials)other);
            }
            return super.with(other);
        }

        @Override
        public Iterator<Credential> iterator() {
            return EnumerationIterator.over((Object)this.credential);
        }

        @Override
        public <C extends Credential, R> R applyToCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec, Function<C, R> function) {
            Assert.checkNotNullParam((String)"credentialType", credentialType);
            return (R)this.credential.castAndApply(credentialType, algorithmName, parameterSpec, function);
        }

        @Override
        public IdentityCredentials withoutMatching(Credential credential) {
            Assert.checkNotNullParam((String)"credential", (Object)credential);
            return this.credential.matches(credential) ? NONE : this;
        }

        @Override
        public IdentityCredentials without(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) {
            Assert.checkNotNullParam((String)"credentialType", credentialType);
            return this.credential.matches(credentialType, algorithmName, parameterSpec) ? NONE : this;
        }

        @Override
        public IdentityCredentials without(Predicate<? super Credential> predicate) {
            Assert.checkNotNullParam((String)"predicate", predicate);
            return predicate.test((Credential)this.credential) ? NONE : this;
        }

        @Override
        public void forEach(Consumer<? super Credential> action) {
            Assert.checkNotNullParam((String)"action", action);
            action.accept((Credential)this.credential);
        }

        @Override
        public int size() {
            return 1;
        }

        public int hashCode() {
            return One.typeHash(this.credential);
        }

        public boolean equals(Object obj) {
            return obj instanceof One && ((One)obj).credential.equals(this.credential);
        }
    }
}

