/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.metadata;

import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.drools.core.factmodel.traits.TraitProxy;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.metadata.AbstractWMTask;
import org.drools.core.metadata.InvertibleMetaProperty;
import org.drools.core.metadata.Lit;
import org.drools.core.metadata.MetaCallableTask;
import org.drools.core.metadata.MetaClass;
import org.drools.core.metadata.MetaProperty;
import org.drools.core.metadata.MetadataContainer;
import org.drools.core.metadata.Modify;
import org.drools.core.metadata.ModifyTask;
import org.drools.core.metadata.With;
import org.drools.core.reteoo.PropertySpecificUtil;
import org.drools.core.util.ClassUtils;
import org.drools.core.util.bitmask.BitMask;

public abstract class ModifyLiteral<T>
extends AbstractWMTask<T>
implements Modify<T>,
Serializable {
    private T target;
    protected ModifyTaskLiteral<T, ?, ?> task;
    protected BitMask modificationMask;
    protected URI key;
    protected Object[] with;
    protected BitMask[] extraMasks;

    protected abstract MetaClass<T> getMetaClassInfo();

    public ModifyLiteral(T target, With[] with) {
        this.target = target;
        switch (with.length) {
            case 0: {
                this.with = null;
                this.extraMasks = null;
                return;
            }
            case 1: {
                this.with = with[0].getArgs();
                break;
            }
            default: {
                this.mergeWiths(with);
            }
        }
        this.extraMasks = new BitMask[this.with.length];
    }

    protected void mergeWiths(With[] with) {
        int j;
        int n = 0;
        for (j = 0; j < with.length; ++j) {
            n += with[j].getArgs().length;
        }
        this.with = new Object[n];
        n = 0;
        for (j = 0; j < with.length; ++j) {
            System.arraycopy(with[j].getArgs(), 0, this.with, n, with[j].getArgs().length);
            n += with[j].getArgs().length;
        }
    }

    @Override
    public ModifyLiteral<T> getSetters() {
        return this;
    }

    @Override
    public T getTarget() {
        return this.target;
    }

    void setTarget(T target) {
        this.target = target;
    }

    @Override
    public ModifyTask getSetterChain() {
        return this.task;
    }

    @Override
    public Object getTargetId() {
        return MetadataContainer.getIdentifier(this.target);
    }

    @Override
    public Object[] getAdditionalUpdates() {
        return this.with;
    }

    @Override
    public BitMask getAdditionalUpdatesModificationMask(int j) {
        return this.extraMasks[j];
    }

    @Override
    public MetaCallableTask.KIND kind() {
        return MetaCallableTask.KIND.MODIFY;
    }

    @Override
    public T call(T object) {
        this.setTarget(object);
        return this.call();
    }

    @Override
    public T call() {
        this.computeModificationMasks(null);
        this.task.call(this.target);
        return this.target;
    }

    @Override
    public T call(InternalKnowledgeBase knowledgeBase) {
        this.computeModificationMasks(knowledgeBase);
        this.task.call(this.target);
        return this.target;
    }

    protected void computeModificationMasks(InternalKnowledgeBase knowledgeBase) {
        List<String> settableProperties = this.getAccessibleProperties(this.target, knowledgeBase);
        this.modificationMask = PropertySpecificUtil.getEmptyPropertyReactiveMask(settableProperties.size());
        if (this.with != null) {
            int j;
            List[] inverseSettableProperties = new List[this.with.length];
            for (j = 0; j < this.with.length; ++j) {
                inverseSettableProperties[j] = this.getAccessibleProperties(this.with[j], knowledgeBase);
                this.extraMasks[j] = PropertySpecificUtil.getEmptyPropertyReactiveMask(inverseSettableProperties[j].size());
            }
            for (j = 0; j < this.with.length; ++j) {
                this.task.computeModificationMasks(this.target.getClass(), this.modificationMask, settableProperties, this.with, this.extraMasks, inverseSettableProperties);
            }
        } else {
            this.task.computeModificationMasks(this.target.getClass(), this.modificationMask, settableProperties, null, null, null);
        }
    }

    protected List<String> getAccessibleProperties(Object o, InternalKnowledgeBase knowledgeBase) {
        if (knowledgeBase != null) {
            return PropertySpecificUtil.getAccessibleProperties(knowledgeBase, o.getClass());
        }
        return ClassUtils.getAccessibleProperties(o.getClass());
    }

    @Override
    public BitMask getModificationMask() {
        return this.modificationMask;
    }

    @Override
    public abstract Class getModificationClass();

    protected <R, C> void addTask(MetaProperty<?, R, C> p, C val) {
        this.addTask(p, val, Lit.SET);
    }

    protected <R, C> void addTask(MetaProperty<?, R, C> p, C val, Lit mode) {
        ModifyTaskLiteral newTask = new ModifyTaskLiteral(p, val, mode);
        if (this.task == null) {
            this.task = newTask;
        } else {
            ModifyTaskLiteral<T, ?, ?> lastTask = this.task;
            while (lastTask.nextTask != null) {
                lastTask = lastTask.nextTask;
            }
            lastTask.nextTask = newTask;
        }
    }

    @Override
    public URI getUri() {
        if (this.key == null) {
            this.key = this.createURI();
        }
        return this.key;
    }

    @Override
    public Object getId() {
        return this.getUri();
    }

    protected URI createURI() {
        StringBuilder sb = new StringBuilder();
        sb.append(MetadataContainer.getIdentifier(this.target));
        sb.append("/modify");
        ModifyTaskLiteral<T, ?, ?> t = this.task;
        while (t != null) {
            sb.append("?").append(t.propertyLiteral.getName());
            t = t.nextTask;
        }
        return URI.create(sb.toString());
    }

    public <S, T> Modify<S> getInverse(T value) {
        InverseModifyLiteral inverse = new InverseModifyLiteral(value);
        ModifyTaskLiteral<T, ?, ?> task = this.task;
        do {
            MetaProperty inv;
            if (!this.isAffected(value, task.value)) continue;
            inverse.addTask(inv, (inv = ((InvertibleMetaProperty)((Object)task.getProperty())).getInverse()).isManyValued() ? Collections.singleton(this.getTarget()) : this.getTarget(), task.mode == Lit.REMOVE ? Lit.REMOVE : Lit.ADD);
        } while ((task = task.nextTask) != null);
        return inverse;
    }

    protected boolean isAffected(Object value, Object taskValue) {
        if (value == taskValue) {
            return true;
        }
        if (taskValue instanceof Collection) {
            Collection coll = (Collection)taskValue;
            for (Object o : coll) {
                if (o == value) {
                    return true;
                }
                if (!(o instanceof TraitProxy) || value != ((TraitProxy)o).getObject()) continue;
                return true;
            }
        }
        return false;
    }

    public static class InverseModifyLiteral
    extends ModifyLiteral {
        private static With[] nargs = new With[0];

        public <X> InverseModifyLiteral(X range) {
            super(range, nargs);
        }

        protected MetaClass getMetaClassInfo() {
            return null;
        }

        @Override
        public Class getModificationClass() {
            return this.getTarget().getClass();
        }

        @Override
        public Object call() {
            throw new UnsupportedOperationException();
        }
    }

    public static class ModifyTaskLiteral<T, R, C>
    implements ModifyTask,
    Serializable {
        protected MetaProperty<T, R, C> propertyLiteral;
        protected C value;
        protected Lit mode;
        protected ModifyTaskLiteral<T, ?, ?> nextTask;

        protected ModifyTaskLiteral(MetaProperty<?, R, C> p, C val, Lit mode) {
            this.propertyLiteral = p;
            this.mode = mode;
            this.value = val;
        }

        public void call(T target) {
            if (this.propertyLiteral.isManyValued()) {
                this.propertyLiteral.asManyValuedProperty().set(target, (List)this.value, this.mode);
            } else {
                this.propertyLiteral.asFunctionalProperty().set(target, this.value, Lit.SET);
            }
            if (this.nextTask != null) {
                this.nextTask.call(target);
            }
        }

        public void computeModificationMasks(Class modifiedClass, BitMask mask, List<String> settableProperties, Object[] with, BitMask[] extraMasks, List<String>[] inverseSettableProperties) {
            if (this.nextTask != null) {
                this.nextTask.computeModificationMasks(modifiedClass, mask, settableProperties, with, extraMasks, inverseSettableProperties);
            }
            PropertySpecificUtil.setPropertyOnMask(modifiedClass, mask, settableProperties, this.propertyLiteral.getName());
            if (with != null) {
                for (int j = 0; j < with.length; ++j) {
                    if (this.value != with[j] || !(this.propertyLiteral instanceof InvertibleMetaProperty)) continue;
                    PropertySpecificUtil.setPropertyOnMask(modifiedClass, extraMasks[j], inverseSettableProperties[j], ((InvertibleMetaProperty)((Object)this.propertyLiteral)).getInverse().getName());
                }
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ModifyTaskLiteral that = (ModifyTaskLiteral)o;
            if (this.nextTask != null ? !this.nextTask.equals(that.nextTask) : that.nextTask != null) {
                return false;
            }
            return this.propertyLiteral.equals(that.propertyLiteral);
        }

        public int hashCode() {
            int result = this.propertyLiteral.hashCode();
            result = 31 * result + (this.nextTask != null ? this.nextTask.hashCode() : 0);
            return result;
        }

        public MetaProperty getProperty() {
            return this.propertyLiteral;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public Lit getMode() {
            return this.mode;
        }

        public ModifyTask getNext() {
            return this.nextTask;
        }
    }
}

