/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.theme;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.common.Version;
import org.keycloak.common.util.StringPropertyReplacer;
import org.keycloak.common.util.SystemEnvProperties;
import org.keycloak.models.KeycloakSession;
import org.keycloak.theme.ExtendingThemeManagerFactory;
import org.keycloak.theme.Theme;
import org.keycloak.theme.ThemeProvider;
import org.keycloak.theme.ThemeResourceProvider;

public class ExtendingThemeManager
implements ThemeProvider {
    private static final Logger log = Logger.getLogger(ExtendingThemeManager.class);
    private final KeycloakSession session;
    private final ConcurrentHashMap<ExtendingThemeManagerFactory.ThemeKey, Theme> themeCache;
    private List<ThemeProvider> providers;
    private String defaultTheme;

    public ExtendingThemeManager(KeycloakSession session, ConcurrentHashMap<ExtendingThemeManagerFactory.ThemeKey, Theme> themeCache) {
        this.session = session;
        this.themeCache = themeCache;
        this.defaultTheme = Config.scope((String[])new String[]{"theme"}).get("default", Version.NAME.toLowerCase());
    }

    private List<ThemeProvider> getProviders() {
        if (this.providers == null) {
            this.providers = new LinkedList<ThemeProvider>();
            for (ThemeProvider p : this.session.getAllProviders(ThemeProvider.class)) {
                if (p instanceof ExtendingThemeManager || p.getClass().equals(ExtendingThemeManager.class)) continue;
                this.providers.add(p);
            }
            Collections.sort(this.providers, new Comparator<ThemeProvider>(){

                @Override
                public int compare(ThemeProvider o1, ThemeProvider o2) {
                    return o2.getProviderPriority() - o1.getProviderPriority();
                }
            });
        }
        return this.providers;
    }

    public int getProviderPriority() {
        return 0;
    }

    public Theme getTheme(String name, Theme.Type type) throws IOException {
        if (name == null) {
            name = this.defaultTheme;
        }
        if (this.themeCache != null) {
            ExtendingThemeManagerFactory.ThemeKey key = ExtendingThemeManagerFactory.ThemeKey.get(name, type);
            Theme theme = this.themeCache.get(key);
            if (theme == null) {
                theme = this.loadTheme(name, type);
                if (theme == null) {
                    theme = this.loadTheme("keycloak", type);
                    if (theme == null) {
                        theme = this.loadTheme("base", type);
                    }
                    log.errorv("Failed to find {0} theme {1}, using built-in themes", (Object)type, (Object)name);
                } else if (this.themeCache.putIfAbsent(key, theme) != null) {
                    theme = this.themeCache.get(key);
                }
            }
            return theme;
        }
        return this.loadTheme(name, type);
    }

    private Theme loadTheme(String name, Theme.Type type) throws IOException {
        Theme theme = this.findTheme(name, type);
        LinkedList<Theme> themes = new LinkedList<Theme>();
        themes.add(theme);
        if (theme.getImportName() != null) {
            String[] s = theme.getImportName().split("/");
            themes.add(this.findTheme(s[1], Theme.Type.valueOf((String)s[0].toUpperCase())));
        }
        if (theme.getParentName() != null) {
            String parentName = theme.getParentName();
            while (parentName != null) {
                theme = this.findTheme(parentName, type);
                themes.add(theme);
                if (theme.getImportName() != null) {
                    String[] s = theme.getImportName().split("/");
                    themes.add(this.findTheme(s[1], Theme.Type.valueOf((String)s[0].toUpperCase())));
                }
                parentName = theme.getParentName();
            }
        }
        return new ExtendingTheme(themes, this.session.getAllProviders(ThemeResourceProvider.class));
    }

    public Set<String> nameSet(Theme.Type type) {
        HashSet<String> themes = new HashSet<String>();
        for (ThemeProvider p : this.getProviders()) {
            themes.addAll(p.nameSet(type));
        }
        return themes;
    }

    public boolean hasTheme(String name, Theme.Type type) {
        for (ThemeProvider p : this.getProviders()) {
            if (!p.hasTheme(name, type)) continue;
            return true;
        }
        return false;
    }

    public void close() {
        this.providers = null;
    }

    private Theme findTheme(String name, Theme.Type type) {
        for (ThemeProvider p : this.getProviders()) {
            if (!p.hasTheme(name, type)) continue;
            try {
                return p.getTheme(name, type);
            }
            catch (IOException e) {
                log.errorv((Throwable)e, p.getClass() + " failed to load theme, type={0}, name={1}", (Object)type, (Object)name);
            }
        }
        return null;
    }

    public static class ExtendingTheme
    implements Theme {
        private List<Theme> themes;
        private Set<ThemeResourceProvider> themeResourceProviders;
        private Properties properties;
        private ConcurrentHashMap<String, ConcurrentHashMap<Locale, Properties>> messages = new ConcurrentHashMap();

        public ExtendingTheme(List<Theme> themes, Set<ThemeResourceProvider> themeResourceProviders) {
            this.themes = themes;
            this.themeResourceProviders = themeResourceProviders;
        }

        public String getName() {
            return this.themes.get(0).getName();
        }

        public String getParentName() {
            return this.themes.get(0).getParentName();
        }

        public String getImportName() {
            return this.themes.get(0).getImportName();
        }

        public Theme.Type getType() {
            return this.themes.get(0).getType();
        }

        public URL getTemplate(String name) throws IOException {
            URL template;
            for (Theme theme : this.themes) {
                template = theme.getTemplate(name);
                if (template == null) continue;
                return template;
            }
            for (ThemeResourceProvider themeResourceProvider : this.themeResourceProviders) {
                template = themeResourceProvider.getTemplate(name);
                if (template == null) continue;
                return template;
            }
            return null;
        }

        public InputStream getResourceAsStream(String path) throws IOException {
            InputStream resource;
            for (Theme theme : this.themes) {
                resource = theme.getResourceAsStream(path);
                if (resource == null) continue;
                return resource;
            }
            for (ThemeResourceProvider themeResourceProvider : this.themeResourceProviders) {
                resource = themeResourceProvider.getResourceAsStream(path);
                if (resource == null) continue;
                return resource;
            }
            return null;
        }

        public Properties getMessages(Locale locale) throws IOException {
            return this.getMessages("messages", locale);
        }

        public Properties getMessages(String baseBundlename, Locale locale) throws IOException {
            if (this.messages.get(baseBundlename) == null || this.messages.get(baseBundlename).get(locale) == null) {
                Properties messages = new Properties();
                if (!Locale.ENGLISH.equals(locale)) {
                    messages.putAll((Map<?, ?>)this.getMessages(baseBundlename, Locale.ENGLISH));
                }
                for (ThemeResourceProvider t : this.themeResourceProviders) {
                    messages.putAll((Map<?, ?>)t.getMessages(baseBundlename, locale));
                }
                ListIterator<Theme> itr = this.themes.listIterator(this.themes.size());
                while (itr.hasPrevious()) {
                    Properties m = itr.previous().getMessages(baseBundlename, locale);
                    if (m == null) continue;
                    messages.putAll((Map<?, ?>)m);
                }
                this.messages.putIfAbsent(baseBundlename, new ConcurrentHashMap());
                this.messages.get(baseBundlename).putIfAbsent(locale, messages);
                return messages;
            }
            return this.messages.get(baseBundlename).get(locale);
        }

        public Properties getProperties() throws IOException {
            if (this.properties == null) {
                Properties properties = new Properties();
                ListIterator<Theme> itr = this.themes.listIterator(this.themes.size());
                while (itr.hasPrevious()) {
                    Properties p = itr.previous().getProperties();
                    if (p == null) continue;
                    properties.putAll((Map<?, ?>)p);
                }
                this.substituteProperties(properties);
                this.properties = properties;
                return properties;
            }
            return this.properties;
        }

        private void substituteProperties(Properties properties) {
            for (String propertyName : properties.stringPropertyNames()) {
                properties.setProperty(propertyName, StringPropertyReplacer.replaceProperties((String)properties.getProperty(propertyName), (Properties)new SystemEnvProperties()));
            }
        }
    }
}

