/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.vault;

import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.vault.FilesPlainTextVaultProvider;
import org.keycloak.vault.VaultNotFoundException;
import org.keycloak.vault.VaultProvider;
import org.keycloak.vault.VaultProviderFactory;

public class FilesPlainTextVaultProviderFactory
implements VaultProviderFactory {
    private static final Logger logger = Logger.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROVIDER_ID = "files-plaintext";
    private String vaultDirectory;
    private Path vaultPath;

    public VaultProvider create(KeycloakSession session) {
        if (this.vaultDirectory == null) {
            logger.debug((Object)"Can not create a vault since it's disabled or not initialized correctly");
            return null;
        }
        return new FilesPlainTextVaultProvider(this.vaultPath, this.getRealmName(session));
    }

    public void init(Config.Scope config) {
        this.vaultDirectory = config.get("dir");
        if (this.vaultDirectory == null) {
            logger.debug((Object)"PlainTextVaultProviderFactory not configured");
            return;
        }
        this.vaultPath = Paths.get(this.vaultDirectory, new String[0]);
        if (!Files.exists(this.vaultPath, new LinkOption[0])) {
            throw new VaultNotFoundException("The " + this.vaultPath.toAbsolutePath().toString() + " directory doesn't exist");
        }
        logger.debugf("Configured PlainTextVaultProviderFactory with directory %s", (Object)this.vaultPath.toString());
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    protected String getRealmName(KeycloakSession session) {
        return session.getContext().getRealm().getName();
    }
}

