/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.xa;

import java.util.concurrent.ConcurrentMap;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.configuration.cache.Configurations;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.LocalXaTransaction;
import org.infinispan.transaction.xa.TransactionXaAdapter;
import org.infinispan.transaction.xa.recovery.RecoveryManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class XaTransactionTable
extends TransactionTable {
    private static final Log log = LogFactory.getLog(XaTransactionTable.class);
    private static final boolean trace = log.isTraceEnabled();
    @Inject
    protected RecoveryManager recoveryManager;
    @ComponentName(value="cacheName")
    @Inject
    protected String cacheName;
    protected ConcurrentMap<Xid, LocalXaTransaction> xid2LocalTx;
    private boolean onePhaseTotalOrder;

    @Start(priority=9)
    public void startXidMapping() {
        this.onePhaseTotalOrder = Configurations.isOnePhaseTotalOrderCommit(this.configuration);
        int concurrencyLevel = this.configuration.locking().concurrencyLevel();
        this.xid2LocalTx = CollectionFactory.makeConcurrentMap((int)concurrencyLevel, (float)0.75f, (int)concurrencyLevel);
    }

    @Override
    public boolean removeLocalTransaction(LocalTransaction localTx) {
        boolean result = false;
        if (localTx.getTransaction() != null) {
            result = super.removeLocalTransaction(localTx);
        }
        this.removeXidTxMapping((LocalXaTransaction)localTx);
        return result;
    }

    private void removeXidTxMapping(LocalXaTransaction localTx) {
        Xid xid = localTx.getXid();
        if (xid != null) {
            this.xid2LocalTx.remove(xid);
        }
    }

    public LocalXaTransaction getLocalTransaction(Xid xid) {
        return (LocalXaTransaction)this.xid2LocalTx.get(xid);
    }

    private void addLocalTransactionMapping(LocalXaTransaction localTransaction) {
        if (localTransaction.getXid() == null) {
            throw new IllegalStateException("Initialize xid first!");
        }
        this.xid2LocalTx.put(localTransaction.getXid(), localTransaction);
    }

    @Override
    public void enlist(Transaction transaction, LocalTransaction ltx) {
        LocalXaTransaction localTransaction = (LocalXaTransaction)ltx;
        if (!localTransaction.isEnlisted()) {
            try {
                transaction.enlistResource((XAResource)new TransactionXaAdapter(localTransaction, this));
            }
            catch (Exception e) {
                Xid xid = localTransaction.getXid();
                if (xid != null && !localTransaction.getLookedUpEntries().isEmpty()) {
                    log.debug("Attempting a rollback to clear stale resources!");
                    try {
                        this.txCoordinator.rollback(localTransaction);
                    }
                    catch (XAException xae) {
                        log.debug("Caught exception attempting to clean up " + xid, xae);
                    }
                }
                log.failedToEnlistTransactionXaAdapter(e);
                throw new CacheException((Throwable)e);
            }
        }
    }

    @Override
    public void enlistClientTransaction(Transaction transaction, LocalTransaction localTransaction) {
        this.enlist(transaction, localTransaction);
    }

    @Override
    public int getLocalTxCount() {
        return this.xid2LocalTx.size();
    }

    public int prepare(Xid externalXid) throws XAException {
        Xid xid = this.convertXid(externalXid);
        LocalXaTransaction localTransaction = this.getLocalTransactionAndValidate(xid);
        return this.txCoordinator.prepare(localTransaction);
    }

    public void commit(Xid externalXid, boolean isOnePhase) throws XAException {
        boolean committedInOnePhase;
        Xid xid = this.convertXid(externalXid);
        LocalXaTransaction localTransaction = this.getLocalTransactionAndValidate(xid);
        if (isOnePhase && this.onePhaseTotalOrder) {
            committedInOnePhase = this.txCoordinator.commit(localTransaction, true);
        } else if (isOnePhase) {
            this.txCoordinator.prepare(localTransaction);
            committedInOnePhase = this.txCoordinator.commit(localTransaction, false);
        } else {
            committedInOnePhase = this.txCoordinator.commit(localTransaction, false);
        }
        this.forgetSuccessfullyCompletedTransaction(this.recoveryManager, localTransaction.getXid(), localTransaction, committedInOnePhase);
    }

    void rollback(Xid externalXid) throws XAException {
        Xid xid = this.convertXid(externalXid);
        LocalXaTransaction localTransaction = this.getLocalTransactionAndValidate(xid);
        localTransaction.markForRollback(true);
        this.txCoordinator.rollback(localTransaction);
    }

    private Xid convertXid(Xid externalXid) {
        if (this.isRecoveryEnabled()) {
            return XidImpl.copy((Xid)externalXid);
        }
        return externalXid;
    }

    void start(Xid externalXid, LocalXaTransaction localTransaction) {
        Xid xid = this.convertXid(externalXid);
        localTransaction.setXid(xid);
        this.addLocalTransactionMapping(localTransaction);
        if (trace) {
            log.tracef("start called on tx %s", localTransaction.getGlobalTransaction());
        }
    }

    void end(LocalXaTransaction localTransaction) {
        if (trace) {
            log.tracef("end called on tx %s(%s)", localTransaction.getGlobalTransaction(), this.cacheName);
        }
    }

    void forget(Xid externalXid) throws XAException {
        Xid xid = this.convertXid(externalXid);
        if (trace) {
            log.tracef("forget called for xid %s", xid);
        }
        try {
            if (this.isRecoveryEnabled()) {
                this.recoveryManager.removeRecoveryInformation(null, xid, true, null, false);
            } else if (trace) {
                log.trace("Recovery not enabled");
            }
        }
        catch (Exception e) {
            log.warnExceptionRemovingRecovery(e);
            XAException xe = new XAException(-3);
            xe.initCause(e);
            throw xe;
        }
    }

    boolean isRecoveryEnabled() {
        return this.recoveryManager != null;
    }

    private void forgetSuccessfullyCompletedTransaction(RecoveryManager recoveryManager, Xid xid, LocalXaTransaction localTransaction, boolean committedInOnePhase) {
        GlobalTransaction gtx = localTransaction.getGlobalTransaction();
        if (this.isRecoveryEnabled()) {
            recoveryManager.removeRecoveryInformation(localTransaction.getRemoteLocksAcquired(), xid, false, gtx, this.partitionHandlingManager.isTransactionPartiallyCommitted(gtx));
            this.removeLocalTransaction(localTransaction);
        } else {
            this.releaseLocksForCompletedTransaction(localTransaction, committedInOnePhase);
        }
    }

    private LocalXaTransaction getLocalTransactionAndValidate(Xid xid) throws XAException {
        LocalXaTransaction localTransaction = this.getLocalTransaction(xid);
        if (localTransaction == null) {
            if (trace) {
                log.tracef("no tx found for %s", xid);
            }
            throw new XAException(-4);
        }
        return localTransaction;
    }
}

