/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks.cs;

import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.blocks.cs.BaseServer;
import org.jgroups.blocks.cs.Connection;
import org.jgroups.blocks.cs.NioConnection;
import org.jgroups.util.SocketFactory;
import org.jgroups.util.ThreadFactory;

public abstract class NioBaseServer
extends BaseServer {
    protected Selector selector;
    protected Thread acceptor;
    protected final Lock reg_lock = new ReentrantLock();
    protected volatile boolean registration;
    @ManagedAttribute(description="Max number of send buffers. Changing this value affects new buffers only", writable=true)
    protected int max_send_buffers = 5;
    @ManagedAttribute(description="Number of times select() was called")
    protected int num_selects;
    protected boolean copy_on_partial_write = true;
    protected long reader_idle_time = 20000L;

    protected NioBaseServer(ThreadFactory f, SocketFactory sf) {
        super(f, sf);
    }

    public int maxSendBuffers() {
        return this.max_send_buffers;
    }

    public NioBaseServer maxSendBuffers(int num) {
        this.max_send_buffers = num;
        return this;
    }

    public boolean selectorOpen() {
        return this.selector != null && this.selector.isOpen();
    }

    public boolean acceptorRunning() {
        return this.acceptor != null && this.acceptor.isAlive();
    }

    public int numSelects() {
        return this.num_selects;
    }

    public boolean copyOnPartialWrite() {
        return this.copy_on_partial_write;
    }

    public long readerIdleTime() {
        return this.reader_idle_time;
    }

    public NioBaseServer readerIdleTime(long t) {
        this.reader_idle_time = t;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NioBaseServer copyOnPartialWrite(boolean b) {
        this.copy_on_partial_write = b;
        NioBaseServer nioBaseServer = this;
        synchronized (nioBaseServer) {
            for (Connection c : this.conns.values()) {
                NioConnection conn = (NioConnection)c;
                conn.copyOnPartialWrite(b);
            }
        }
        return this;
    }

    public synchronized int numPartialWrites() {
        int retval = 0;
        for (Connection c : this.conns.values()) {
            NioConnection conn = (NioConnection)c;
            retval += conn.numPartialWrites();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation(description="Prints the send and receive buffers")
    public String printBuffers() {
        StringBuilder sb = new StringBuilder("\n");
        NioBaseServer nioBaseServer = this;
        synchronized (nioBaseServer) {
            for (Map.Entry entry : this.conns.entrySet()) {
                NioConnection val = (NioConnection)entry.getValue();
                sb.append(entry.getKey()).append(":\n  ").append("recv_buf: ").append(val.recv_buf).append("\n  send_buf: ").append(val.send_buf).append("\n");
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SelectionKey register(SelectableChannel ch, int interest_ops, NioConnection conn) throws Exception {
        this.reg_lock.lock();
        try {
            this.registration = true;
            this.selector.wakeup();
            SelectionKey selectionKey = ch.register(this.selector, interest_ops, conn);
            return selectionKey;
        }
        finally {
            this.reg_lock.unlock();
        }
    }

    @Override
    protected NioConnection createConnection(Address dest) throws Exception {
        return new NioConnection(dest, this).copyOnPartialWrite(this.copy_on_partial_write);
    }

    protected void handleAccept(SelectionKey key) throws Exception {
    }

    protected void acceptorDone() {
    }

    protected class Acceptor
    implements Runnable {
        protected Acceptor() {
        }

        @Override
        public void run() {
            Iterator<SelectionKey> it = null;
            while (NioBaseServer.this.running.get() && this.doSelect()) {
                try {
                    it = NioBaseServer.this.selector.selectedKeys().iterator();
                }
                catch (Throwable ex) {
                    continue;
                }
                while (it.hasNext()) {
                    SelectionKey key = it.next();
                    NioConnection conn = (NioConnection)key.attachment();
                    it.remove();
                    try {
                        SocketChannel ch;
                        if (!key.isValid()) continue;
                        if (key.isReadable()) {
                            conn.receive();
                        }
                        if (key.isWritable()) {
                            conn.send();
                        }
                        if (key.isAcceptable()) {
                            NioBaseServer.this.handleAccept(key);
                            continue;
                        }
                        if (!key.isConnectable() || !(ch = (SocketChannel)key.channel()).finishConnect() && !ch.isConnected()) continue;
                        conn.clearSelectionKey(8);
                        conn.connected(true);
                    }
                    catch (Throwable ex) {
                        NioBaseServer.this.closeConnection(conn, ex);
                    }
                }
            }
            NioBaseServer.this.acceptorDone();
        }

        protected boolean doSelect() {
            try {
                int num = NioBaseServer.this.selector.select();
                ++NioBaseServer.this.num_selects;
                this.checkforPendingRegistrations();
                if (num == 0) {
                    return true;
                }
            }
            catch (ClosedSelectorException closed_ex) {
                NioBaseServer.this.log.trace("selector was closed; acceptor terminating");
                return false;
            }
            catch (Throwable t) {
                NioBaseServer.this.log.warn("acceptor failure", t);
            }
            return true;
        }

        protected void checkforPendingRegistrations() {
            if (NioBaseServer.this.registration) {
                NioBaseServer.this.reg_lock.lock();
                try {
                    NioBaseServer.this.registration = false;
                }
                finally {
                    NioBaseServer.this.reg_lock.unlock();
                }
            }
        }
    }
}

