/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.model;

import com.openshift.internal.restclient.model.ExecAction;
import com.openshift.restclient.model.IHandler;
import com.openshift.restclient.model.ILifecycle;
import java.util.Optional;
import org.jboss.dmr.ModelNode;

public class Lifecycle
implements ILifecycle {
    private static final String PRESTOP = "preStop";
    private static final String POSTSTART = "postStart";
    private final Optional<IHandler> postStart;
    private final Optional<IHandler> preStop;

    private Lifecycle(Optional<IHandler> preStop, Optional<IHandler> postStart) {
        this.preStop = preStop;
        this.postStart = postStart;
    }

    @Override
    public Optional<IHandler> getPostStart() {
        return this.postStart;
    }

    @Override
    public Optional<IHandler> getPreStop() {
        return this.preStop;
    }

    @Override
    public String toJson() {
        ModelNode node = new ModelNode();
        this.preStop.ifPresent(handler -> node.get(PRESTOP).get(handler.getType()).set(ModelNode.fromJSONString((String)handler.toJson())));
        this.postStart.ifPresent(handler -> node.get(POSTSTART).get(handler.getType()).set(ModelNode.fromJSONString((String)handler.toJson())));
        return node.toJSONString(true);
    }

    public static ILifecycle fromJson(ModelNode json) {
        Builder builder = new Builder();
        if (json.has(PRESTOP)) {
            builder.preStop(Lifecycle.parseHandler(json.get(PRESTOP)).orElse(null));
        }
        if (json.has(POSTSTART)) {
            builder.postStart(Lifecycle.parseHandler(json.get(POSTSTART)).orElse(null));
        }
        return builder.build();
    }

    private static Optional<IHandler> parseHandler(ModelNode node) {
        if (node.has("exec")) {
            return Optional.of(ExecAction.fromJson(node.get("exec")));
        }
        return Optional.empty();
    }

    public static class Builder
    implements ILifecycle.IBuilder {
        private IHandler preStop = null;
        private IHandler postStart = null;

        @Override
        public ILifecycle build() {
            return new Lifecycle(Optional.ofNullable(this.preStop), Optional.ofNullable(this.postStart));
        }

        @Override
        public Builder postStart(IHandler handler) {
            this.postStart = handler;
            return this;
        }

        @Override
        public Builder preStop(IHandler handler) {
            this.preStop = handler;
            return this;
        }
    }
}

