/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.threads;

import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeoutException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.threads.ExecutionInterruptedException;
import org.jboss.threads.ExecutionTimedOutException;
import org.jboss.threads.InterruptHandler;
import org.jboss.threads.StoppedExecutorException;
import org.jboss.threads.ThreadCreationException;

@MessageLogger(projectCode="JBTHR", length=5)
interface Messages
extends BasicLogger {
    public static final Messages msg = Logger.getMessageLogger(Messages.class, "org.jboss.threads");
    public static final Messages intMsg = Logger.getMessageLogger(Messages.class, "org.jboss.threads.interrupt-handler");

    @Message(value="JBoss Threads version %s")
    @LogMessage(level=Logger.Level.INFO)
    public void version(String var1);

    @Message(id=1, value="Thread factory did not produce a thread")
    public ThreadCreationException noThreadCreated();

    @Message(id=2, value="Task limit reached")
    public RejectedExecutionException taskLimitReached();

    @Message(id=3, value="Operation timed out")
    public TimeoutException operationTimedOut();

    @Message(id=4, value="Operation was cancelled")
    public CancellationException operationCancelled();

    @Message(id=5, value="Operation failed")
    public ExecutionException operationFailed(@Cause Throwable var1);

    @Message(id=6, value="Unable to add new thread to the running set")
    public ThreadCreationException cannotAddThread();

    @Deprecated
    @Message(id=7, value="Task execution interrupted")
    public ExecutionInterruptedException executionInterrupted();

    @Message(id=8, value="Task rejected")
    public RejectedExecutionException executionRejected();

    @Message(id=9, value="Executor has been shut down")
    public StoppedExecutorException shutDownInitiated();

    @Deprecated
    @Message(id=10, value="Task execution timed out")
    public ExecutionTimedOutException executionTimedOut();

    @Message(id=11, value="Task execution failed for task %s")
    @LogMessage(level=Logger.Level.ERROR)
    public void executionFailed(@Cause Throwable var1, Runnable var2);

    @Message(id=12, value="Cannot await termination of a thread pool from one of its own threads")
    public IllegalStateException cannotAwaitWithin();

    @Message(id=13, value="No executors available to run task")
    public RejectedExecutionException noExecutorsAvailable();

    @Message(id=14, value="Error submitting task %s to executor")
    @LogMessage(level=Logger.Level.ERROR)
    public void taskSubmitFailed(@Cause RejectedExecutionException var1, Runnable var2);

    @Message(id=100, value="Keep-alive may only be set to 0 for this executor type")
    public IllegalArgumentException keepAliveNotZero();

    @Message(id=101, value="Cannot reduce maximum threads below current thread number of running threads")
    public IllegalArgumentException cannotReduceMaxBelowCurrent();

    @Message(id=102, value="Empty array parameter is not empty")
    public IllegalArgumentException arrayNotEmpty();

    @Message(id=103, value="The current thread does not support interrupt handlers")
    public IllegalStateException noInterruptHandlers();

    @Deprecated
    @Message(id=104, value="Executor is not shut down")
    public IllegalStateException notShutDown();

    @Message(id=105, value="Concurrent modification of collection detected")
    public ConcurrentModificationException concurrentModification();

    @Message(id=106, value="No such element (iteration past end)")
    public NoSuchElementException noSuchElement();

    @Message(id=107, value="Unknown throwable received")
    public RuntimeException unknownThrowable(@Cause Throwable var1);

    @Message(id=108, value="Interrupt handler %s threw an exception")
    @LogMessage(level=Logger.Level.ERROR)
    public void interruptHandlerThrew(@Cause Throwable var1, InterruptHandler var2);

    @Message(id=200, value="%s() not allowed on container-managed executor")
    public SecurityException notAllowedContainerManaged(String var1);
}

