/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.spnego;

import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.sasl.AuthorizeCallback;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.wildfly.common.Assert;
import org.wildfly.common.array.Arrays2;
import org.wildfly.common.iteration.ByteIterator;
import org.wildfly.security.auth.callback.AuthenticationCompleteCallback;
import org.wildfly.security.auth.callback.CachedIdentityAuthorizeCallback;
import org.wildfly.security.auth.callback.IdentityCredentialCallback;
import org.wildfly.security.auth.callback.ServerCredentialCallback;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.cache.CachedIdentity;
import org.wildfly.security.cache.IdentityCache;
import org.wildfly.security.credential.GSSKerberosCredential;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpConstants;
import org.wildfly.security.http.HttpScope;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerRequest;
import org.wildfly.security.http.HttpServerResponse;
import org.wildfly.security.http.Scope;
import org.wildfly.security.mechanism.AuthenticationMechanismException;
import org.wildfly.security.mechanism._private.ElytronMessages;
import org.wildfly.security.mechanism._private.MechanismUtil;
import org.wildfly.security.mechanism.gssapi.GSSCredentialSecurityFactory;

public final class SpnegoAuthenticationMechanism
implements HttpServerAuthenticationMechanism {
    private static final String CHALLENGE_PREFIX = "Negotiate ";
    private static final String SPNEGO_CONTEXT_KEY = SpnegoAuthenticationMechanism.class.getName() + ".spnego-context";
    private static final String CACHED_IDENTITY_KEY = SpnegoAuthenticationMechanism.class.getName() + ".elytron-identity";
    private static final byte[] NEG_STATE_REJECT = new byte[]{-95, 7, 48, 5, -96, 3, 10, 1, 2};
    private final CallbackHandler callbackHandler;
    private final GSSManager gssManager;
    private final Scope[] storageScopes;

    SpnegoAuthenticationMechanism(CallbackHandler callbackHandler, Map<String, ?> properties) {
        String scopesProperty;
        Assert.checkNotNullParam("callbackHandler", callbackHandler);
        Assert.checkNotNullParam("properties", properties);
        this.callbackHandler = callbackHandler;
        GSSManager gSSManager = this.gssManager = properties.containsKey(HttpConstants.CONFIG_GSS_MANAGER) ? (GSSManager)properties.get(HttpConstants.CONFIG_GSS_MANAGER) : GSSManager.getInstance();
        if (properties.containsKey(HttpConstants.CONFIG_CREATE_NAME_GSS_INIT) && Boolean.parseBoolean((String)properties.get(HttpConstants.CONFIG_CREATE_NAME_GSS_INIT))) {
            try {
                this.gssManager.createName("dummy", GSSName.NT_USER_NAME, GSSCredentialSecurityFactory.SPNEGO);
                ElytronMessages.httpSpnego.trace("createName workaround for native GSS initialization applied");
            }
            catch (GSSException e) {
                ElytronMessages.httpSpnego.trace("Exception while applying createName workaround for native GSS initialization", e);
            }
        }
        if ((scopesProperty = (String)properties.get(HttpConstants.CONFIG_STATE_SCOPES)) == null) {
            this.storageScopes = new Scope[]{Scope.SESSION, Scope.CONNECTION};
        } else {
            String[] names = scopesProperty.split(",");
            this.storageScopes = new Scope[names.length];
            for (int i = 0; i < names.length; ++i) {
                if ("NONE".equals(names[i])) {
                    this.storageScopes[i] = null;
                    continue;
                }
                Scope scope = Scope.valueOf(names[i]);
                if (scope == Scope.APPLICATION || scope == Scope.GLOBAL) {
                    throw ElytronMessages.httpSpnego.unsuitableScope(scope.name());
                }
                this.storageScopes[i] = scope;
            }
        }
    }

    @Override
    public String getMechanismName() {
        return "SPNEGO";
    }

    @Override
    public void evaluateRequest(HttpServerRequest request) throws HttpAuthenticationException {
        HttpScope storageScope = this.getStorageScope(request);
        IdentityCache identityCache = null;
        if ((identityCache = this.createIdentityCache(identityCache, storageScope, false)) != null && this.attemptReAuthentication(identityCache, request)) {
            ElytronMessages.httpSpnego.trace("Successfully authorized using cached identity");
            return;
        }
        SpnegoContext spnegoContext = storageScope != null && storageScope.exists() ? storageScope.getAttachment(SPNEGO_CONTEXT_KEY, SpnegoContext.class) : null;
        GSSContext gssContext = spnegoContext != null ? spnegoContext.gssContext : null;
        KerberosTicket kerberosTicket = spnegoContext != null ? spnegoContext.kerberosTicket : null;
        ElytronMessages.httpSpnego.tracef("Evaluating SPNEGO request: cached GSSContext = %s", (Object)gssContext);
        if (gssContext != null && gssContext.isEstablished()) {
            if (this.authorizeSrcName(gssContext, identityCache = this.createIdentityCache(identityCache, storageScope, true))) {
                ElytronMessages.httpSpnego.trace("Successfully authorized using cached GSSContext");
                request.authenticationComplete();
                return;
            }
            SpnegoAuthenticationMechanism.clearAttachments(storageScope);
            gssContext = null;
            kerberosTicket = null;
        }
        if (gssContext == null) {
            GSSCredential serviceGssCredential;
            if (spnegoContext == null) {
                spnegoContext = new SpnegoContext();
            }
            ServerCredentialCallback gssCredentialCallback = new ServerCredentialCallback(GSSKerberosCredential.class);
            try {
                ElytronMessages.httpSpnego.trace("Obtaining GSSCredential for the service from callback handler...");
                this.callbackHandler.handle(new Callback[]{gssCredentialCallback});
                serviceGssCredential = gssCredentialCallback.applyToCredential(GSSKerberosCredential.class, GSSKerberosCredential::getGssCredential);
                kerberosTicket = gssCredentialCallback.applyToCredential(GSSKerberosCredential.class, GSSKerberosCredential::getKerberosTicket);
            }
            catch (IOException | UnsupportedCallbackException e) {
                throw ElytronMessages.httpSpnego.mechCallbackHandlerFailedForUnknownReason(e).toHttpAuthenticationException();
            }
            if (serviceGssCredential == null) {
                throw ElytronMessages.httpSpnego.unableToObtainServerCredential().toHttpAuthenticationException();
            }
            try {
                gssContext = this.gssManager.createContext(serviceGssCredential);
                if (ElytronMessages.httpSpnego.isTraceEnabled()) {
                    ElytronMessages.httpSpnego.tracef("Using SpnegoAuthenticationMechanism to authenticate %s using the following mechanisms: [%s]", (Object)serviceGssCredential.getName(), (Object)Arrays2.objectToString(serviceGssCredential.getMechs()));
                }
            }
            catch (GSSException e) {
                throw ElytronMessages.httpSpnego.mechUnableToCreateGssContext(e).toHttpAuthenticationException();
            }
            spnegoContext.gssContext = gssContext;
            spnegoContext.kerberosTicket = kerberosTicket;
        }
        List<String> authorizationValues = request.getRequestHeaderValues("Authorization");
        String challenge = null;
        if (authorizationValues != null && !authorizationValues.isEmpty()) {
            for (String current : authorizationValues) {
                if (!current.startsWith(CHALLENGE_PREFIX)) continue;
                challenge = current.substring(CHALLENGE_PREFIX.length());
                break;
            }
        }
        if (ElytronMessages.httpSpnego.isTraceEnabled()) {
            ElytronMessages.httpSpnego.tracef("Sent HTTP authorizations: [%s]", (Object)Arrays2.objectToString(authorizationValues));
        }
        if (challenge != null) {
            byte[] responseToken;
            ElytronMessages.httpSpnego.trace("Processing incoming response to a challenge...");
            if (storageScope != null && (storageScope.exists() || storageScope.create())) {
                ElytronMessages.httpSpnego.tracef("Caching SPNEGO Context with GSSContext %s and KerberosTicket %s", (Object)gssContext, (Object)kerberosTicket);
                storageScope.setAttachment(SPNEGO_CONTEXT_KEY, spnegoContext);
            } else {
                storageScope = null;
                ElytronMessages.httpSpnego.trace("No usable HttpScope for storage, continuation will not be possible");
            }
            byte[] decodedValue = ByteIterator.ofBytes(challenge.getBytes(StandardCharsets.UTF_8)).asUtf8String().base64Decode().drain();
            Subject subject = new Subject(true, Collections.emptySet(), Collections.emptySet(), kerberosTicket != null ? Collections.singleton(kerberosTicket) : Collections.emptySet());
            try {
                GSSContext finalGssContext = gssContext;
                responseToken = Subject.doAs(subject, () -> finalGssContext.acceptSecContext(decodedValue, 0, decodedValue.length));
            }
            catch (PrivilegedActionException e) {
                ElytronMessages.httpSpnego.trace("Call to acceptSecContext failed.", e.getCause());
                this.handleCallback(AuthenticationCompleteCallback.FAILED);
                SpnegoAuthenticationMechanism.clearAttachments(storageScope);
                request.authenticationFailed(ElytronMessages.httpSpnego.authenticationFailed());
                return;
            }
            if (gssContext.isEstablished()) {
                GSSCredential gssCredential;
                try {
                    gssCredential = gssContext.getCredDelegState() ? gssContext.getDelegCred() : null;
                }
                catch (GSSException e) {
                    ElytronMessages.httpSpnego.trace("Unable to access delegated credential despite being delegated.", e);
                    this.handleCallback(AuthenticationCompleteCallback.FAILED);
                    SpnegoAuthenticationMechanism.clearAttachments(storageScope);
                    request.authenticationFailed(ElytronMessages.httpSpnego.authenticationFailed());
                    return;
                }
                if (gssCredential != null) {
                    ElytronMessages.httpSpnego.trace("Associating delegated GSSCredential with identity.");
                    this.handleCallback(new IdentityCredentialCallback(new GSSKerberosCredential(gssCredential), true));
                } else {
                    ElytronMessages.httpSpnego.trace("No GSSCredential delegated from client.");
                }
                ElytronMessages.httpSpnego.trace("GSSContext established, authorizing...");
                identityCache = this.createIdentityCache(identityCache, storageScope, true);
                if (this.authorizeSrcName(gssContext, identityCache)) {
                    ElytronMessages.httpSpnego.trace("GSSContext established and authorized - authentication complete");
                    request.authenticationComplete(responseToken == null ? null : response -> this.sendChallenge(responseToken, response, 0));
                } else {
                    ElytronMessages.httpSpnego.trace("Authorization of established GSSContext failed");
                    this.handleCallback(AuthenticationCompleteCallback.FAILED);
                    SpnegoAuthenticationMechanism.clearAttachments(storageScope);
                    request.authenticationFailed(ElytronMessages.httpSpnego.authenticationFailed(), responseToken == null ? null : response -> this.sendChallenge(responseToken, response, 403));
                }
            } else if (Arrays.equals(responseToken, NEG_STATE_REJECT)) {
                ElytronMessages.httpSpnego.trace("GSSContext failed - sending negotiation rejected to the peer");
                request.authenticationFailed(ElytronMessages.httpSpnego.authenticationFailed(), response -> this.sendChallenge(responseToken, response, 403));
            } else if (responseToken != null && storageScope != null) {
                ElytronMessages.httpSpnego.trace("GSSContext establishing - sending negotiation token to the peer");
                request.authenticationInProgress(response -> this.sendChallenge(responseToken, response, 401));
            } else {
                ElytronMessages.httpSpnego.trace("GSSContext establishing - unable to hold GSSContext so continuation will not be possible");
                this.handleCallback(AuthenticationCompleteCallback.FAILED);
                request.authenticationFailed(ElytronMessages.httpSpnego.authenticationFailed());
            }
        } else {
            ElytronMessages.httpSpnego.trace("Request lacks valid authentication credentials");
            SpnegoAuthenticationMechanism.clearAttachments(storageScope);
            request.noAuthenticationInProgress(this::sendBareChallenge);
        }
    }

    private HttpScope getStorageScope(HttpServerRequest request) throws HttpAuthenticationException {
        for (Scope scope : this.storageScopes) {
            if (scope == null) {
                return null;
            }
            HttpScope httpScope = request.getScope(scope);
            if (httpScope != null && httpScope.supportsAttachments()) {
                if (ElytronMessages.httpSpnego.isTraceEnabled()) {
                    ElytronMessages.httpSpnego.tracef("Using HttpScope '%s' with ID '%s'", (Object)scope.name(), (Object)httpScope.getID());
                }
                return httpScope;
            }
            if (!ElytronMessages.httpSpnego.isTraceEnabled()) continue;
            ElytronMessages.httpSpnego.tracef(httpScope == null ? "HttpScope %s not supported" : "HttpScope %s does not support attachments", (Object)scope);
        }
        throw ElytronMessages.httpSpnego.unableToIdentifyHttpScope();
    }

    private IdentityCache createIdentityCache(IdentityCache existingCache, final HttpScope httpScope, boolean forUpdate) {
        if (!(existingCache == null && httpScope != null && httpScope.supportsAttachments() && (httpScope.exists() || forUpdate && httpScope.create()))) {
            return existingCache;
        }
        return new IdentityCache(){

            @Override
            public CachedIdentity remove() {
                CachedIdentity cachedIdentity = this.get();
                httpScope.setAttachment(CACHED_IDENTITY_KEY, null);
                return cachedIdentity;
            }

            @Override
            public void put(SecurityIdentity identity) {
                httpScope.setAttachment(CACHED_IDENTITY_KEY, new CachedIdentity("SPNEGO", identity));
            }

            @Override
            public CachedIdentity get() {
                return httpScope.getAttachment(CACHED_IDENTITY_KEY, CachedIdentity.class);
            }
        };
    }

    private static void clearAttachments(HttpScope scope) {
        if (scope != null) {
            scope.setAttachment(SPNEGO_CONTEXT_KEY, null);
        }
    }

    private void sendBareChallenge(HttpServerResponse response) {
        response.addResponseHeader("WWW-Authenticate", "Negotiate");
        response.setStatusCode(401);
    }

    private void sendChallenge(byte[] responseToken, HttpServerResponse response, int statusCode) {
        if (ElytronMessages.httpSpnego.isTraceEnabled()) {
            ElytronMessages.httpSpnego.tracef("Sending intermediate challenge: %s", (Object)Arrays2.objectToString(responseToken));
        }
        if (responseToken == null) {
            response.addResponseHeader("WWW-Authenticate", "Negotiate");
        } else {
            String responseConverted = ByteIterator.ofBytes(responseToken).base64Encode().drainToString();
            response.addResponseHeader("WWW-Authenticate", CHALLENGE_PREFIX + responseConverted);
        }
        if (statusCode != 0) {
            response.setStatusCode(statusCode);
        }
    }

    private boolean attemptReAuthentication(IdentityCache identityCache, HttpServerRequest request) throws HttpAuthenticationException {
        CachedIdentityAuthorizeCallback authorizeCallback = new CachedIdentityAuthorizeCallback(identityCache);
        try {
            this.callbackHandler.handle(new Callback[]{authorizeCallback});
        }
        catch (IOException | UnsupportedCallbackException e) {
            throw new HttpAuthenticationException(e);
        }
        if (authorizeCallback.isAuthorized()) {
            try {
                this.handleCallback(AuthenticationCompleteCallback.SUCCEEDED);
            }
            catch (IOException e) {
                throw new HttpAuthenticationException(e);
            }
            request.authenticationComplete(null, identityCache::remove);
            return true;
        }
        return false;
    }

    private boolean authorizeSrcName(GSSContext gssContext, IdentityCache identityCache) throws HttpAuthenticationException {
        GSSName srcName;
        try {
            srcName = gssContext.getSrcName();
            if (srcName == null) {
                ElytronMessages.httpSpnego.trace("Authorization failed - srcName of GSSContext (name of initiator) is null - wrong realm or kdc?");
                return false;
            }
        }
        catch (GSSException e) {
            ElytronMessages.httpSpnego.trace("Unable to obtain srcName from established GSSContext.", e);
            return false;
        }
        if (gssContext.getCredDelegState()) {
            try {
                GSSCredential credential = gssContext.getDelegCred();
                ElytronMessages.httpSpnego.tracef("Credential delegation enabled, delegated credential = %s", (Object)credential);
                MechanismUtil.handleCallbacks(ElytronMessages.httpSpnego, this.callbackHandler, new IdentityCredentialCallback(new GSSKerberosCredential(credential), true));
            }
            catch (UnsupportedCallbackException credential) {
            }
            catch (AuthenticationMechanismException e) {
                throw e.toHttpAuthenticationException();
            }
            catch (GSSException e) {
                throw new HttpAuthenticationException(e);
            }
        } else {
            ElytronMessages.httpSpnego.trace("Credential delegation not enabled");
        }
        boolean authorized = false;
        try {
            Callback authorizeCallBack;
            BooleanSupplier authorizedFunction;
            String clientName = srcName.toString();
            if (identityCache != null) {
                CachedIdentityAuthorizeCallback cacheCallback = new CachedIdentityAuthorizeCallback((Principal)new NamePrincipal(clientName), identityCache, true);
                authorizedFunction = cacheCallback::isAuthorized;
                authorizeCallBack = cacheCallback;
            } else {
                AuthorizeCallback plainCallback = new AuthorizeCallback(clientName, clientName);
                authorizedFunction = plainCallback::isAuthorized;
                authorizeCallBack = plainCallback;
            }
            this.callbackHandler.handle(new Callback[]{authorizeCallBack});
            authorized = authorizedFunction.getAsBoolean();
            ElytronMessages.httpSpnego.tracef("Authorized by callback handler = %b  clientName = [%s]", (Object)authorized, (Object)clientName);
        }
        catch (IOException e) {
            ElytronMessages.httpSpnego.trace("IOException during AuthorizeCallback handling", e);
            throw ElytronMessages.httpSpnego.mechServerSideAuthenticationFailed(e).toHttpAuthenticationException();
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            // empty catch block
        }
        if (authorized) {
            this.handleCallback(AuthenticationCompleteCallback.SUCCEEDED);
        }
        return authorized;
    }

    private void handleCallback(Callback callback) throws HttpAuthenticationException {
        try {
            MechanismUtil.handleCallbacks(ElytronMessages.httpSpnego, this.callbackHandler, callback);
        }
        catch (AuthenticationMechanismException e) {
            throw e.toHttpAuthenticationException();
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            // empty catch block
        }
    }

    private static class SpnegoContext
    implements Serializable {
        private static final long serialVersionUID = 1168213910107551573L;
        transient GSSContext gssContext;
        transient KerberosTicket kerberosTicket;

        private SpnegoContext() {
        }
    }
}

