/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.authorization.events;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;
import org.keycloak.models.cache.infinispan.authorization.StoreFactoryCacheManager;
import org.keycloak.models.cache.infinispan.authorization.events.AuthorizationCacheInvalidationEvent;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;

@SerializeWith(value=ExternalizerImpl.class)
public class ScopeRemovedEvent
extends InvalidationEvent
implements AuthorizationCacheInvalidationEvent {
    private String id;
    private String name;
    private String serverId;

    public static ScopeRemovedEvent create(String id, String name, String serverId) {
        ScopeRemovedEvent event = new ScopeRemovedEvent();
        event.id = id;
        event.name = name;
        event.serverId = serverId;
        return event;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String toString() {
        return String.format("ScopeRemovedEvent [ id=%s, name=%s]", this.id, this.name);
    }

    @Override
    public void addInvalidations(StoreFactoryCacheManager cache, Set<String> invalidations) {
        cache.scopeRemoval(this.id, this.name, this.serverId, invalidations);
    }

    public static class ExternalizerImpl
    implements Externalizer<ScopeRemovedEvent> {
        private static final int VERSION_1 = 1;

        public void writeObject(ObjectOutput output, ScopeRemovedEvent obj) throws IOException {
            output.writeByte(1);
            MarshallUtil.marshallString((String)obj.id, (ObjectOutput)output);
            MarshallUtil.marshallString((String)obj.name, (ObjectOutput)output);
            MarshallUtil.marshallString((String)obj.serverId, (ObjectOutput)output);
        }

        public ScopeRemovedEvent readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            switch (input.readByte()) {
                case 1: {
                    return this.readObjectVersion1(input);
                }
            }
            throw new IOException("Unknown version");
        }

        public ScopeRemovedEvent readObjectVersion1(ObjectInput input) throws IOException, ClassNotFoundException {
            ScopeRemovedEvent res = new ScopeRemovedEvent();
            res.id = MarshallUtil.unmarshallString((ObjectInput)input);
            res.name = MarshallUtil.unmarshallString((ObjectInput)input);
            res.serverId = MarshallUtil.unmarshallString((ObjectInput)input);
            return res;
        }
    }
}

