/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.vdx.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.Deque;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.projectodd.vdx.core.DocElement;
import org.projectodd.vdx.core.Position;
import org.projectodd.vdx.core.Tree;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class DocWalker {
    private final URL document;
    private Tree<DocElement> tree = null;
    private SAXParseException validationFailure = null;

    public DocWalker(URL document) {
        this.document = document;
    }

    public Tree<DocElement> walk() {
        if (this.tree == null) {
            this.tree = new Tree();
            final ArrayDeque<Tree<DocElement>> stack = new ArrayDeque<Tree<DocElement>>();
            stack.push(this.tree);
            DefaultHandler handler = new DefaultHandler(){
                private Locator locator = null;
                private Position lastPosition = new Position(1, 2);
                private Deque<String> nsStack = new ArrayDeque<String>();

                @Override
                public void setDocumentLocator(Locator locator) {
                    this.locator = locator;
                }

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    String namespace = attributes.getValue("xmlns");
                    if (namespace != null) {
                        this.nsStack.push(namespace);
                    } else {
                        this.nsStack.push(this.nsStack.peek());
                    }
                    stack.push(((Tree)stack.peek()).addChild(new DocElement(this.qname(qName), attributes).startPosition(this.lastPosition)));
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    Position pos = this.position();
                    ((DocElement)((Tree)stack.peek()).value()).endPosition(pos);
                    this.storePosition(pos);
                    stack.pop();
                    this.nsStack.pop();
                }

                @Override
                public void characters(char[] ch, int start, int length) throws SAXException {
                    this.storePosition(this.position());
                }

                @Override
                public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
                    this.storePosition(this.position());
                }

                private void storePosition(Position current) {
                    if (current.line > this.lastPosition.line || current.line == this.lastPosition.line && current.col > this.lastPosition.col) {
                        this.lastPosition = current;
                    }
                }

                private QName qname(String local) {
                    if (this.nsStack.peek() != null) {
                        return new QName(this.nsStack.peek(), local);
                    }
                    return QName.valueOf(local);
                }

                private Position position() {
                    return new Position(this.locator.getLineNumber(), this.locator.getColumnNumber());
                }
            };
            try (InputStream in = this.document.openStream();){
                SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                XMLReader reader = parser.getXMLReader();
                reader.setContentHandler(handler);
                reader.parse(new InputSource(in));
            }
            catch (SAXParseException e) {
                this.validationFailure = e;
            }
            catch (IOException | ParserConfigurationException | SAXException exception) {
                // empty catch block
            }
        }
        return this.tree;
    }

    public boolean valid() {
        this.walk();
        return this.validationFailure == null;
    }

    public SAXParseException validationFailure() {
        this.walk();
        return this.validationFailure;
    }
}

