/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.eviction.impl;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.IteratorMapper;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.context.impl.ImmutableContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.eviction.PassivationManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.marshall.core.MarshalledEntryFactory;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.persistence.PersistenceUtil;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class PassivationManagerImpl
implements PassivationManager {
    private static final Log log = LogFactory.getLog(PassivationManagerImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    @Inject
    private PersistenceManager persistenceManager;
    @Inject
    private CacheNotifier notifier;
    @Inject
    private Configuration cfg;
    @Inject
    private InternalDataContainer<Object, Object> container;
    @Inject
    private TimeService timeService;
    @Inject
    private MarshalledEntryFactory marshalledEntryFactory;
    @Inject
    private DistributionManager distributionManager;
    @Inject
    private KeyPartitioner keyPartitioner;
    private volatile boolean skipOnStop = false;
    boolean statsEnabled = false;
    boolean enabled = false;
    private final AtomicLong passivations = new AtomicLong(0L);

    @Start(priority=12)
    public void start() {
        boolean bl = this.enabled = this.cfg.persistence().passivation() && this.cfg.persistence().usingStores();
        if (this.enabled) {
            this.statsEnabled = this.cfg.jmxStatistics().enabled();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    private boolean isL1Key(Object key) {
        return this.distributionManager != null && !this.distributionManager.getCacheTopology().isWriteOwner(key);
    }

    @Override
    public void passivate(InternalCacheEntry entry) {
        Object key;
        if (this.enabled && entry != null && !this.isL1Key(key = entry.getKey())) {
            this.notifier.notifyCacheEntryPassivated(key, entry.getValue(), true, ImmutableContext.INSTANCE, null);
            if (trace) {
                log.tracef("Passivating entry %s", Util.toStr(key));
            }
            try {
                MarshalledEntry marshalledEntry = this.marshalledEntryFactory.newMarshalledEntry(key, entry.getValue(), PersistenceUtil.internalMetadata(entry));
                this.persistenceManager.writeToAllNonTxStores(marshalledEntry, this.keyPartitioner.getSegment(key), PersistenceManager.AccessMode.BOTH);
                if (this.statsEnabled) {
                    this.passivations.getAndIncrement();
                }
            }
            catch (CacheException e) {
                log.unableToPassivateEntry(key, (Exception)((Object)e));
            }
            this.notifier.notifyCacheEntryPassivated(key, null, false, ImmutableContext.INSTANCE, null);
        }
    }

    @Override
    public void passivateAll() throws PersistenceException {
        if (this.enabled && !this.skipOnStop) {
            long start = this.timeService.time();
            log.passivatingAllEntries();
            int count = this.container.sizeIncludingExpired();
            Iterable<MarshalledEntry> iterable = () -> new IteratorMapper(this.container.iterator(), e -> this.marshalledEntryFactory.newMarshalledEntry(e.getKey(), e.getValue(), PersistenceUtil.internalMetadata(e)));
            this.persistenceManager.writeBatchToAllNonTxStores(iterable, PersistenceManager.AccessMode.BOTH, 0L);
            log.passivatedEntries(count, Util.prettyPrintTime((long)this.timeService.timeDuration(start, TimeUnit.MILLISECONDS)));
        }
    }

    @Override
    public void skipPassivationOnStop(boolean skip) {
        this.skipOnStop = skip;
    }

    @Override
    public long getPassivations() {
        return this.passivations.get();
    }

    @Override
    public boolean getStatisticsEnabled() {
        return this.statsEnabled;
    }

    @Override
    public void setStatisticsEnabled(boolean enabled) {
        this.statsEnabled = enabled;
    }

    @Override
    public void resetStatistics() {
        this.passivations.set(0L);
    }
}

